/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class TypedFieldImplTest {
    private static final String FIELD_NAME = "instance";
    private TypesImpl types;

    TypedFieldImplTest() {
    }

    @BeforeEach
    void setUp() {
        ConstantPools constantPools = new ConstantPools();
        MetadataImpl metadata = new MetadataImpl(constantPools);
        this.types = new TypesImpl(metadata);
    }

    @Test
    void getCustomTypeNoAnnotations() {
        TypeImpl type = this.types.getOrAdd("custom.Type", t -> t.addField("field", (Types.Predefined)Types.Builtin.STRING).addAnnotation((Type)this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_LABEL), "custom.Type"));
        TypedFieldImpl instance = new TypedFieldImpl(type, FIELD_NAME);
        Assertions.assertEquals((Object)FIELD_NAME, (Object)instance.getName());
        Assertions.assertEquals((Object)type, (Object)instance.getType());
        Assertions.assertEquals((int)0, (int)instance.getAnnotations().size());
        Assertions.assertFalse((boolean)instance.isArray());
    }

    @Test
    void getCustomTypeAnnotations() {
        TypeImpl type = this.types.getOrAdd("custom.Type", t -> t.addField("field", (Types.Predefined)Types.Builtin.STRING).addAnnotation((Type)this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_LABEL), "custom.Type"));
        TypedFieldImpl instance = new TypedFieldImpl(type, FIELD_NAME, false, Collections.singletonList(new Annotation((Type)this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_LABEL), "field")));
        Assertions.assertEquals((Object)FIELD_NAME, (Object)instance.getName());
        Assertions.assertEquals((Object)type, (Object)instance.getType());
        Assertions.assertEquals((int)1, (int)instance.getAnnotations().size());
        Assertions.assertFalse((boolean)instance.isArray());
    }

    @Test
    void getCustomTypeArrayNoAnnotations() {
        TypeImpl type = this.types.getOrAdd("custom.Type", t -> t.addField("field", (Types.Predefined)Types.Builtin.STRING).addAnnotation((Type)this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_LABEL), "custom.Type"));
        TypedFieldImpl instance = new TypedFieldImpl(type, FIELD_NAME, true);
        Assertions.assertEquals((Object)FIELD_NAME, (Object)instance.getName());
        Assertions.assertEquals((Object)type, (Object)instance.getType());
        Assertions.assertEquals((int)0, (int)instance.getAnnotations().size());
        Assertions.assertTrue((boolean)instance.isArray());
    }

    @Test
    void getCustomTypeArrayAnnotations() {
        TypeImpl type = this.types.getOrAdd("custom.Type", t -> t.addField("field", (Types.Predefined)Types.Builtin.STRING).addAnnotation((Type)this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_LABEL), "custom.Type"));
        TypedFieldImpl instance = new TypedFieldImpl(type, FIELD_NAME, true, Collections.singletonList(new Annotation((Type)this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_LABEL), "field")));
        Assertions.assertEquals((Object)FIELD_NAME, (Object)instance.getName());
        Assertions.assertEquals((Object)type, (Object)instance.getType());
        Assertions.assertEquals((int)1, (int)instance.getAnnotations().size());
        Assertions.assertTrue((boolean)instance.isArray());
    }

    @Test
    void equality() {
        TypeImpl[] fieldTypes = new TypeImpl[]{this.types.getOrAdd("custom.Type", t -> t.addField("field", (Types.Predefined)Types.Builtin.STRING).addAnnotation((Type)this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_LABEL), "custom.Type")), this.types.getType((Types.Predefined)Types.Builtin.STRING)};
        String[] fieldNames = new String[]{"field1", "field2"};
        boolean[] arrayFlags = new boolean[]{true, false};
        List<List> annotations = Arrays.asList(Collections.emptyList(), Collections.singletonList(new Annotation((Type)this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_LABEL), "field")));
        ArrayList<TypedFieldImpl> fields = new ArrayList<TypedFieldImpl>();
        for (TypeImpl fieldType : fieldTypes) {
            for (String fieldName : fieldNames) {
                for (boolean arrayFlag : arrayFlags) {
                    for (List annotationList : annotations) {
                        fields.add(new TypedFieldImpl(fieldType, fieldName, arrayFlag, annotationList));
                    }
                }
            }
        }
        for (TypedFieldImpl field1 : fields) {
            Assertions.assertFalse((boolean)field1.equals((Object)10));
            Assertions.assertFalse((boolean)field1.equals(null));
            for (TypedFieldImpl field2 : fields) {
                Assertions.assertEquals((Object)(field1 == field2 ? 1 : 0), (Object)field1.equals((Object)field2));
                Assertions.assertTrue((field1.hashCode() != field2.hashCode() || field1.equals((Object)field2) ? 1 : 0) != 0);
            }
        }
    }
}

