/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openjdk.jmc.flightrecorder.writer.BaseType;
import org.openjdk.jmc.flightrecorder.writer.BuiltinType;
import org.openjdk.jmc.flightrecorder.writer.ConstantPool;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeUtils;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class BuiltinTypeTest {
    private static final long TYPE_ID = 1L;
    private BuiltinType instance;
    private TypesImpl types;

    BuiltinTypeTest() {
    }

    @BeforeEach
    void setUp() {
        MetadataImpl metadata = (MetadataImpl)Mockito.mock(MetadataImpl.class);
        this.types = new TypesImpl(metadata);
        this.instance = new BuiltinType(1L, Types.Builtin.INT, (ConstantPools)Mockito.mock(ConstantPools.class), this.types);
    }

    @Test
    void isBuiltin() {
        Assertions.assertTrue((boolean)this.instance.isBuiltin());
    }

    @Test
    void isResolved() {
        Assertions.assertTrue((boolean)this.instance.isResolved());
    }

    @Test
    void nullValue() {
        TypedValueImpl value = this.instance.nullValue();
        Assertions.assertNotNull((Object)value);
        Assertions.assertTrue((boolean)value.isNull());
        Assertions.assertEquals((Object)value, (Object)this.instance.nullValue());
    }

    @Test
    void getFields() {
        Assertions.assertTrue((boolean)this.instance.getFields().isEmpty());
    }

    @Test
    void getField() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.getField("field"));
    }

    @Test
    void getAnnotations() {
        Assertions.assertTrue((boolean)this.instance.getAnnotations().isEmpty());
    }

    @Test
    void getId() {
        Assertions.assertEquals((long)1L, (long)this.instance.getId());
    }

    @Test
    void getTypeName() {
        Assertions.assertEquals((Object)Types.Builtin.INT.getTypeName(), (Object)this.instance.getTypeName());
    }

    @Test
    void getSupertype() {
        Assertions.assertNull((Object)this.instance.getSupertype());
    }

    @Test
    void isUsedBy() {
        BuiltinType other = new BuiltinType(1L, Types.Builtin.STRING, (ConstantPools)Mockito.mock(ConstantPools.class), this.types);
        Assertions.assertFalse((boolean)this.instance.isUsedBy(null));
        Assertions.assertFalse((boolean)this.instance.isUsedBy((Type)this.instance));
        Assertions.assertFalse((boolean)this.instance.isUsedBy((Type)other));
    }

    @ParameterizedTest
    @EnumSource(value=Types.Builtin.class)
    void canAccept(Types.Builtin target) {
        BuiltinType type = new BuiltinType(1L, target, (ConstantPools)Mockito.mock(ConstantPools.class), this.types);
        for (Types.Builtin builtin : Types.Builtin.values()) {
            for (Object value : TypeUtils.getBuiltinValues(builtin)) {
                Assertions.assertEquals((Object)(target == builtin || value == null ? 1 : 0), (Object)type.canAccept(value));
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=Types.Builtin.class)
    void equality(Types.Builtin target) {
        BuiltinType type1 = new BuiltinType(1L, target, (ConstantPools)Mockito.mock(ConstantPools.class), this.types);
        for (Types.Builtin builtin : Types.Builtin.values()) {
            BuiltinType type2 = new BuiltinType(1L, builtin, (ConstantPools)Mockito.mock(ConstantPools.class), this.types);
            Assertions.assertFalse((boolean)type1.equals(null));
            Assertions.assertTrue((boolean)type1.equals((Object)type1));
            Assertions.assertEquals((Object)(target == builtin ? 1 : 0), (Object)type1.equals((Object)type2));
            Assertions.assertEquals((Object)(target == builtin ? 1 : 0), (Object)type2.equals((Object)type1));
        }
    }

    @ParameterizedTest
    @EnumSource(value=Types.Builtin.class)
    void asValue(Types.Builtin target) throws Exception {
        ConstantPools constantPools = (ConstantPools)Mockito.mock(ConstantPools.class);
        Mockito.when((Object)constantPools.forType((TypeImpl)ArgumentMatchers.any(TypeImpl.class))).thenAnswer(i -> new ConstantPool((TypeImpl)i.getArgument(0)));
        BuiltinType type = new BuiltinType(1L, target, (ConstantPools)(target == Types.Builtin.STRING ? constantPools : null), this.types);
        for (Types.Builtin builtin : Types.Builtin.values()) {
            for (Object fromValue : TypeUtils.getBuiltinValues(builtin)) {
                Method asValueMethod = BuiltinTypeTest.getAsValueMethod(builtin);
                if (target == builtin) {
                    TypedValueImpl typedValue = (TypedValueImpl)asValueMethod.invoke((Object)type, fromValue);
                    Assertions.assertNotNull((Object)typedValue);
                    Assertions.assertEquals(fromValue, (Object)typedValue.getValue());
                    continue;
                }
                try {
                    asValueMethod.invoke((Object)type, fromValue);
                    if (fromValue == null) continue;
                    Assertions.fail((String)("Attempted conversion of a value of type '" + builtin.getTypeClass() + "' to '" + target.getTypeClass() + "'"));
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof IllegalArgumentException) continue;
                    Assertions.fail((Throwable)e);
                }
            }
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> BuiltinTypeTest.lambda$asValue$3((BaseType)type));
    }

    private static Method getAsValueMethod(Types.Builtin type) throws Exception {
        return BaseType.class.getMethod("asValue", type.getTypeClass());
    }

    private static /* synthetic */ void lambda$asValue$3(BaseType type) throws Throwable {
        type.asValue(v -> v.putField("f1", "no value"));
    }
}

