/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.list;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.list.AbstractListCommand;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnJavaListCommand
extends AbstractListCommand
implements SvnCommand {
    public ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        boolean recursive = parameters == null ? false : parameters.getBoolean(CommandParameter.RECURSIVE);
        ScmVersion scmVersion = parameters == null ? null : parameters.getScmVersion(CommandParameter.SCM_VERSION, null);
        return this.executeListCommand(repository, fileSet, recursive, scmVersion);
    }

    protected ListScmResult executeListCommand(ScmProviderRepository scmProviderRepository, ScmFileSet scmFileSet, boolean recursive, ScmVersion version) throws ScmException {
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)scmProviderRepository;
        String url = javaRepo.getUrl();
        SVNRevision revision = SVNRevision.HEAD;
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            if (version instanceof ScmTag) {
                url = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)javaRepo, (ScmTag)((ScmTag)version));
            } else if (version instanceof ScmBranch) {
                url = SvnTagBranchUtils.resolveBranchUrl((SvnScmProviderRepository)javaRepo, (ScmBranch)((ScmBranch)version));
            } else if (version instanceof ScmRevision) {
                try {
                    revision = SVNRevision.create((long)Long.parseLong(((ScmRevision)version).getName()));
                }
                catch (NumberFormatException exc) {
                    return new ListScmResult("JavaSVN Library", "SVN checkout failed. Wrong format of revision number.", null, false);
                }
            }
        }
        if (url != null) {
            url = SvnCommandUtils.fixUrl((String)url, (String)javaRepo.getUser());
        }
        ListEntryHandler listEntryHandler = new ListEntryHandler();
        try {
            javaRepo.getClientManager().getLogClient().doList(url == null ? javaRepo.getSvnUrl() : SVNURL.parseURIEncoded((String)url), revision, revision, true, SVNDepth.IMMEDIATES, 0, (ISVNDirEntryHandler)listEntryHandler);
        }
        catch (SVNException e) {
            throw new ScmException("Error while executing svn list.", (Throwable)e);
        }
        ArrayList<ScmFile> scmFiles = new ArrayList<ScmFile>(listEntryHandler.relativePaths.size());
        for (String path : listEntryHandler.relativePaths) {
            scmFiles.add(new ScmFile(path, ScmFileStatus.CHECKED_IN));
        }
        ListScmResult listScmResult = new ListScmResult(scmFiles, new ScmResult(null, null, null, false));
        return listScmResult;
    }

    private static class ListEntryHandler
    implements ISVNDirEntryHandler {
        private List<String> relativePaths = new ArrayList<String>();

        private ListEntryHandler() {
        }

        public void handleDirEntry(SVNDirEntry svnDirEntry) throws SVNException {
            if (StringUtils.isNotEmpty((String)svnDirEntry.getRelativePath())) {
                this.relativePaths.add(svnDirEntry.getRelativePath());
            }
        }
    }
}

