/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.provider.streaming;

import java.io.OutputStream;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.ArtifactSinkException;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IArtifactSink;

class StreamArtifactSink
implements IArtifactSink {
    private IArtifactKey requestedKey;
    private OutputStream destination;
    private boolean writeStarted = false;

    StreamArtifactSink(IArtifactKey requestedKey, OutputStream destination) {
        this.requestedKey = requestedKey;
        this.destination = destination;
    }

    @Override
    public IArtifactKey getArtifactToBeWritten() {
        return this.requestedKey;
    }

    @Override
    public boolean canBeginWrite() {
        return !this.writeStarted;
    }

    @Override
    public OutputStream beginWrite() throws ArtifactSinkException {
        if (this.writeStarted) {
            throw new IllegalStateException("Cannot re-start write operation");
        }
        this.writeStarted = true;
        return this.destination;
    }

    @Override
    public void commitWrite() throws ArtifactSinkException {
    }

    @Override
    public void abortWrite() throws ArtifactSinkException {
    }
}

