/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.SelectorResolutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.EngineDiscoveryResult;
import org.junit.platform.launcher.LauncherDiscoveryListener;

class CompositeLauncherDiscoveryListener
extends LauncherDiscoveryListener {
    private final List<LauncherDiscoveryListener> listeners;

    CompositeLauncherDiscoveryListener(List<LauncherDiscoveryListener> listeners) {
        this.listeners = Collections.unmodifiableList(new ArrayList<LauncherDiscoveryListener>(listeners));
    }

    @Override
    public void engineDiscoveryStarted(UniqueId engineId) {
        this.listeners.forEach(delegate -> delegate.engineDiscoveryStarted(engineId));
    }

    @Override
    public void engineDiscoveryFinished(UniqueId engineId, EngineDiscoveryResult result) {
        this.listeners.forEach(delegate -> delegate.engineDiscoveryFinished(engineId, result));
    }

    @Override
    public void selectorProcessed(UniqueId engineId, DiscoverySelector selector, SelectorResolutionResult result) {
        this.listeners.forEach(delegate -> delegate.selectorProcessed(engineId, selector, result));
    }
}

