/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.scm.providers.starteam.settings.Settings;
import org.apache.maven.scm.providers.starteam.settings.io.xpp3.StarteamXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class StarteamUtil {
    protected static final String STARTEAM_SETTINGS_FILENAME = "starteam-settings.xml";
    public static final File DEFAULT_SETTINGS_DIRECTORY;
    private static File settingsDirectory;
    private static Settings settings;

    private StarteamUtil() {
    }

    public static Settings getSettings() {
        if (settings == null) {
            settings = StarteamUtil.readSettings();
        }
        return settings;
    }

    public static Settings readSettings() {
        File settingsFile = StarteamUtil.getSettingsFile();
        if (settingsFile.exists()) {
            StarteamXpp3Reader reader = new StarteamXpp3Reader();
            try {
                return reader.read((Reader)ReaderFactory.newXmlReader((File)settingsFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            catch (XmlPullParserException e) {
                String message = settingsFile.getAbsolutePath() + " isn't well formed. SKIPPED." + e.getMessage();
                System.err.println(message);
            }
        }
        return new Settings();
    }

    public static File getSettingsFile() {
        return new File(settingsDirectory, STARTEAM_SETTINGS_FILENAME);
    }

    public static void setSettingsDirectory(File directory) {
        settingsDirectory = directory;
    }

    static {
        settingsDirectory = DEFAULT_SETTINGS_DIRECTORY = new File(System.getProperty("user.home"), ".scm");
    }
}

