/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.io.IOToolkit;

public class IOToolkitTest {
    private static final int[] MAGIC_ZIP = new int[]{80, 75, 3, 4};
    private static final int[] MAGIC_GZ = new int[]{31, 139};
    private static final String UNCOMPRESSED = "test.txt";
    private static final String GZ = "test.txt.gz";
    private static final String LZ4 = "test.txt.lz4";
    private static final String ZIP = "test.txt.zip";
    private static final String GURKA = "Gurka";

    @Test
    public void testGetMagics() {
        Assert.assertArrayEquals((int[])MAGIC_ZIP, (int[])IOToolkit.getZipMagic());
        Assert.assertArrayEquals((int[])MAGIC_GZ, (int[])IOToolkit.getGzipMagic());
    }

    @Test
    public void testUncompressUncompressed() throws IOException {
        InputStream uncompressedStream = IOToolkit.openUncompressedStream((InputStream)this.getStream(UNCOMPRESSED));
        String string = this.readFromStream(uncompressedStream);
        Assert.assertEquals((String)"String should be Gurka", (Object)GURKA, (Object)string);
    }

    @Test
    public void testUncompressZipped() throws IOException {
        InputStream uncompressedStream = IOToolkit.openUncompressedStream((InputStream)this.getStream(ZIP));
        String string = this.readFromStream(uncompressedStream);
        Assert.assertEquals((String)"String should be Gurka", (Object)GURKA, (Object)string);
    }

    @Test
    public void testUncompressGZipped() throws IOException {
        InputStream uncompressedStream = IOToolkit.openUncompressedStream((InputStream)this.getStream(GZ));
        String string = this.readFromStream(uncompressedStream);
        Assert.assertEquals((String)"String should be Gurka", (Object)GURKA, (Object)string);
    }

    @Test
    public void testUncompressLZ4() throws IOException {
        InputStream uncompressedStream = IOToolkit.openUncompressedStream((InputStream)this.getStream(LZ4));
        String string = this.readFromStream(uncompressedStream);
        Assert.assertEquals((String)"String should be Gurka", (Object)GURKA, (Object)string);
    }

    public InputStream getStream(String resourceName) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (stream == null) {
            throw new IOException("Could not find the resource " + resourceName);
        }
        return stream;
    }

    public String readFromStream(InputStream stream) throws IOException {
        StringBuilder builder = new StringBuilder();
        int c = 0;
        while ((c = stream.read()) != -1) {
            builder.append((char)c);
        }
        return builder.toString();
    }
}

