/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.unit;

import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.unit.DecimalPrefix;

public class DecimalPrefixTest
extends MCTestCase {
    @Test
    public void testZero() {
        Assert.assertEquals((long)0L, (long)DecimalPrefix.getFloorLog1000((double)0.0));
        Assert.assertEquals((Object)DecimalPrefix.NONE, (Object)DecimalPrefix.getEngFloorPrefix((double)0.0));
    }

    @Test
    public void testYocto() {
        double yoctos = 2.0 * Math.pow(10.0, -24.0);
        Assert.assertEquals((long)-8L, (long)DecimalPrefix.getFloorLog1000((double)yoctos));
        Assert.assertEquals((Object)DecimalPrefix.YOCTO, (Object)DecimalPrefix.getEngFloorPrefix((double)yoctos));
        Assert.assertEquals((long)-8L, (long)DecimalPrefix.getFloorLog1000((double)(-yoctos)));
        Assert.assertEquals((Object)DecimalPrefix.YOCTO, (Object)DecimalPrefix.getEngFloorPrefix((double)(-yoctos)));
    }

    @Test
    public void testZepto() {
        double zeptos = 2.0 * Math.pow(10.0, -21.0);
        Assert.assertEquals((long)-7L, (long)DecimalPrefix.getFloorLog1000((double)zeptos));
        Assert.assertEquals((Object)DecimalPrefix.ZEPTO, (Object)DecimalPrefix.getEngFloorPrefix((double)zeptos));
        Assert.assertEquals((long)-7L, (long)DecimalPrefix.getFloorLog1000((double)(-zeptos)));
        Assert.assertEquals((Object)DecimalPrefix.ZEPTO, (Object)DecimalPrefix.getEngFloorPrefix((double)(-zeptos)));
    }

    @Test
    public void testYotta() {
        double yottas = 2.0 * Math.pow(10.0, 24.0);
        Assert.assertEquals((long)8L, (long)DecimalPrefix.getFloorLog1000((double)yottas));
        Assert.assertEquals((Object)DecimalPrefix.YOTTA, (Object)DecimalPrefix.getEngFloorPrefix((double)yottas));
        Assert.assertEquals((long)8L, (long)DecimalPrefix.getFloorLog1000((double)(-yottas)));
        Assert.assertEquals((Object)DecimalPrefix.YOTTA, (Object)DecimalPrefix.getEngFloorPrefix((double)(-yottas)));
    }

    @Test
    public void testZetta() {
        double zettas = 2.0 * Math.pow(10.0, 21.0);
        Assert.assertEquals((long)7L, (long)DecimalPrefix.getFloorLog1000((double)zettas));
        Assert.assertEquals((Object)DecimalPrefix.ZETTA, (Object)DecimalPrefix.getEngFloorPrefix((double)zettas));
        Assert.assertEquals((long)7L, (long)DecimalPrefix.getFloorLog1000((double)(-zettas)));
        Assert.assertEquals((Object)DecimalPrefix.ZETTA, (Object)DecimalPrefix.getEngFloorPrefix((double)(-zettas)));
    }
}

