/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.unit;

import java.text.DecimalFormatSymbols;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;

public class AdHocQuantityTest
extends MCTestCase {
    private char decimalSep;
    private LinearKindOfQuantity length;
    private LinearUnit um;
    private LinearUnit mm;
    private LinearUnit cm;
    private LinearUnit m;
    private LinearUnit km;
    private IQuantity a4width;
    private IQuantity a4length;

    @Before
    public void setUp() throws Exception {
        this.decimalSep = DecimalFormatSymbols.getInstance().getDecimalSeparator();
        ContentType classInitWorkaround = UnitLookup.RAW_NUMBER;
        this.length = new LinearKindOfQuantity("length", "m", (Enum)DecimalPrefix.YOCTO, (Enum)DecimalPrefix.YOTTA);
        this.um = this.length.getUnit((IPrefix)DecimalPrefix.MICRO);
        this.mm = this.length.getUnit((IPrefix)DecimalPrefix.MILLI);
        this.cm = this.length.getUnit((IPrefix)DecimalPrefix.CENTI);
        this.m = this.length.getUnit((IPrefix)DecimalPrefix.NONE);
        this.km = this.length.getUnit((IPrefix)DecimalPrefix.KILO);
        this.a4width = this.mm.quantity(211L);
        this.a4length = this.cm.quantity(29.7);
    }

    @Test
    public void testComparision() {
        AdHocQuantityTest.assertGreaterThan(this.a4width, this.a4length);
    }

    @Test
    public void testDecimalUnitConversion() throws Exception {
        Assert.assertEquals((long)297L, (long)this.a4length.longValueIn((IUnit)this.mm, 300L));
        Assert.assertEquals((double)297.0, (double)this.a4length.doubleValueIn((IUnit)this.mm), (double)0.0);
        Assert.assertEquals((double)0.297, (double)this.a4length.doubleValueIn((IUnit)this.m), (double)0.0);
        Assert.assertEquals((double)2.97E-4, (double)this.a4length.doubleValueIn((IUnit)this.km), (double)0.0);
        Assert.assertEquals((double)21.1, (double)this.a4width.doubleValueIn((IUnit)this.cm), (double)0.0);
        Assert.assertEquals((long)211L, (long)this.a4width.longValueIn((IUnit)this.mm, 211L));
    }

    @Test
    public void testDecimalUnitConversionProblem() {
        try {
            Assert.assertEquals((long)211L, (long)this.a4width.longValueIn((IUnit)this.mm, 210L));
            Assert.fail((String)"Expected exception not thrown!");
        }
        catch (QuantityConversionException qce) {
            Assert.assertEquals((Object)QuantityConversionException.Problem.TOO_HIGH, (Object)qce.getProblem());
            Assert.assertEquals((Object)"210 mm", (Object)qce.getPersistablePrototype());
        }
    }

    @Test
    public void testDecimalUnitConversionProblemNeg() throws Exception {
        ITypedQuantity negA4width = this.mm.quantity(-211L);
        Assert.assertEquals((long)-211L, (long)negA4width.longValueIn((IUnit)this.mm, 210L));
        try {
            Assert.assertEquals((long)-211L, (long)negA4width.longValueIn((IUnit)this.mm, 209L));
            Assert.fail((String)"Expected exception not thrown!");
        }
        catch (QuantityConversionException qce) {
            Assert.assertEquals((Object)QuantityConversionException.Problem.TOO_LOW, (Object)qce.getProblem());
            Assert.assertEquals((Object)"-210 mm", (Object)qce.getPersistablePrototype());
        }
    }

    @Test
    public void testDecimalUnitConversionProblemDouble() {
        try {
            Assert.assertEquals((long)297L, (long)this.a4length.longValueIn((IUnit)this.mm, 296L));
            Assert.fail((String)"Expected exception not thrown!");
        }
        catch (QuantityConversionException qce) {
            Assert.assertEquals((Object)QuantityConversionException.Problem.TOO_HIGH, (Object)qce.getProblem());
            Assert.assertEquals((Object)"296 mm", (Object)qce.getPersistablePrototype());
        }
    }

    @Test
    public void testDecimalUnitConversionProblemNegDouble() throws Exception {
        ITypedQuantity negA4length = this.cm.quantity(-29.7);
        Assert.assertEquals((long)-297L, (long)negA4length.longValueIn((IUnit)this.mm, 296L));
        try {
            Assert.assertEquals((long)-297L, (long)negA4length.longValueIn((IUnit)this.mm, 295L));
            Assert.fail((String)"Expected exception not thrown!");
        }
        catch (QuantityConversionException qce) {
            Assert.assertEquals((Object)QuantityConversionException.Problem.TOO_LOW, (Object)qce.getProblem());
            Assert.assertEquals((Object)"-296 mm", (Object)qce.getPersistablePrototype());
        }
    }

    @Test
    public void testBinaryUnitConversion() throws Exception {
        LinearKindOfQuantity info = new LinearKindOfQuantity("information", "B", (Enum)BinaryPrefix.NOBI, (Enum)BinaryPrefix.YOBI);
        LinearUnit octet = info.getUnit((IPrefix)BinaryPrefix.NOBI);
        LinearUnit bit = info.makeUnit("b", octet.quantity(0.125), "bit");
        LinearUnit kiB = info.getUnit((IPrefix)BinaryPrefix.KIBI);
        LinearUnit MiB = info.getUnit((IPrefix)BinaryPrefix.MEBI);
        LinearUnit TiB = info.getUnit((IPrefix)BinaryPrefix.TEBI);
        ITypedQuantity onekB = kiB.quantity(1L);
        ITypedQuantity oneMB = MiB.quantity(1L);
        ITypedQuantity oneTB = TiB.quantity(1L);
        Assert.assertEquals((long)1024L, (long)onekB.longValueIn((IUnit)octet));
        Assert.assertEquals((long)0x100000L, (long)oneMB.longValueIn((IUnit)octet, Integer.MAX_VALUE));
        Assert.assertEquals((long)0x80000000000L, (long)oneTB.longValueIn((IUnit)bit));
    }

    @Test
    public void testImperialUnitConversion() {
        LinearUnit inch = this.length.makeUnit("in", this.um.quantity(25400L), "inch");
        LinearUnit foot = this.length.makeUnit("ft", inch.quantity(12L), "foot");
        LinearUnit yard = this.length.makeUnit("yd", foot.quantity(3L), "yard");
        Assert.assertEquals((double)30.48, (double)foot.quantity(1L).doubleValueIn((IUnit)this.cm), (double)1.0E-5);
        Assert.assertEquals((double)304.8, (double)foot.quantity(1L).doubleValueIn((IUnit)this.mm), (double)1.0E-4);
        Assert.assertEquals((double)0.9144, (double)yard.quantity(1L).doubleValueIn((IUnit)this.m), (double)1.0E-8);
        Assert.assertEquals((double)36.0, (double)yard.quantity(1L).doubleValueIn((IUnit)inch), (double)1.0E-4);
    }

    @Test
    public void testPersisted() throws Exception {
        ITypedQuantity len = this.length.parsePersisted("1.2019 m");
        Assert.assertEquals((long)1L, (long)len.longValue());
        Assert.assertEquals((long)1201L, (long)len.longValueIn((IUnit)this.mm));
        ITypedQuantity mm100 = this.length.parsePersisted("100 mm");
        Assert.assertEquals((long)100L, (long)mm100.longValue());
    }

    @Test
    public void testPersistedUnparseable() throws Exception {
        try {
            this.length.parsePersisted("120.0.4 cm");
            Assert.fail((String)"Expected exception not thrown!");
        }
        catch (QuantityConversionException qce) {
            Assert.assertEquals((Object)QuantityConversionException.Problem.UNPARSEABLE, (Object)qce.getProblem());
        }
    }

    @Test
    public void testPersistedNoUnit() throws Exception {
        try {
            this.length.parsePersisted("1200.4");
            Assert.fail((String)"Expected exception not thrown!");
        }
        catch (QuantityConversionException qce) {
            Assert.assertEquals((Object)QuantityConversionException.Problem.NO_UNIT, (Object)qce.getProblem());
        }
    }

    @Test
    public void testPersistedUnknownUnit() throws Exception {
        try {
            this.length.parsePersisted("1200.4 a");
            Assert.fail((String)"Expected exception not thrown!");
        }
        catch (QuantityConversionException qce) {
            Assert.assertEquals((Object)QuantityConversionException.Problem.UNKNOWN_UNIT, (Object)qce.getProblem());
        }
    }

    public static void assertPersistedRoundtrip(IQuantity quantity) throws QuantityConversionException {
        KindOfQuantity kind = quantity.getUnit().getContentType();
        String storedText = quantity.persistableString();
        ITypedQuantity newQuantity = kind.parsePersisted(storedText);
        Assert.assertEquals((Object)quantity, (Object)newQuantity);
    }

    @Test
    public void testPersistedLong() throws Exception {
        AdHocQuantityTest.assertPersistedRoundtrip(this.a4width);
        Random rnd = new Random(17L);
        for (int i = 0; i < 1000; ++i) {
            ITypedQuantity length = this.um.quantity(rnd.nextLong());
            AdHocQuantityTest.assertPersistedRoundtrip((IQuantity)length);
        }
    }

    @Test
    public void testPersistedDouble() throws Exception {
        AdHocQuantityTest.assertPersistedRoundtrip(this.a4length);
        Random rnd = new Random(17L);
        for (int i = 0; i < 1000; ++i) {
            ITypedQuantity length = this.um.quantity(rnd.nextDouble());
            AdHocQuantityTest.assertPersistedRoundtrip((IQuantity)length);
        }
    }

    @Test
    public void testInteractive() throws Exception {
        ITypedQuantity len = this.length.parseInteractive("1" + this.decimalSep + "2019 m");
        Assert.assertEquals((long)1L, (long)len.longValue());
        Assert.assertEquals((long)1201L, (long)len.longValueIn((IUnit)this.mm));
        ITypedQuantity mm100 = this.length.parseInteractive("100 mm");
        Assert.assertEquals((long)100L, (long)mm100.longValue());
    }

    @Test
    public void testInteractiveHexadecimal() throws Exception {
        ITypedQuantity address = UnitLookup.ADDRESS.parseInteractive("0x47");
        Assert.assertEquals((long)71L, (long)address.longValue());
        address = UnitLookup.ADDRESS.parseInteractive("0xaf");
        Assert.assertEquals((long)175L, (long)address.longValue());
        address = UnitLookup.ADDRESS.parseInteractive("0xAF");
        Assert.assertEquals((long)175L, (long)address.longValue());
        boolean gotException = false;
        try {
            address = UnitLookup.ADDRESS.parseInteractive("0xgg");
        }
        catch (QuantityConversionException e) {
            gotException = true;
        }
        Assert.assertTrue((String)"Managed to parse bad hex number without exception!", (boolean)gotException);
    }

    @Test
    public void testInteractiveHexadecimalBytes() throws Exception {
        ITypedQuantity mem = UnitLookup.MEMORY.parseInteractive("0x47 KiB");
        Assert.assertEquals((long)71L, (long)mem.longValue());
        Assert.assertEquals((long)72704L, (long)mem.in((IUnit)UnitLookup.BYTE).longValue());
        mem = UnitLookup.MEMORY.parseInteractive("0xaf KiB");
        Assert.assertEquals((long)175L, (long)mem.longValue());
        mem = UnitLookup.MEMORY.parseInteractive("0xAF KiB");
        Assert.assertEquals((long)175L, (long)mem.longValue());
        boolean gotException = false;
        try {
            mem = UnitLookup.MEMORY.parseInteractive("0xgg KiB");
        }
        catch (QuantityConversionException e) {
            gotException = true;
        }
        Assert.assertTrue((String)"Managed to parse bad hex number without exception!", (boolean)gotException);
        gotException = false;
        try {
            mem = UnitLookup.MEMORY.parseInteractive("0xaf");
        }
        catch (QuantityConversionException e) {
            gotException = true;
        }
        Assert.assertTrue((String)"Managed to parse hex number without unit without exception!", (boolean)gotException);
    }

    @Test
    public void testInteractiveUnparseable() throws Exception {
        try {
            this.length.parseInteractive("120" + this.decimalSep + "0" + this.decimalSep + "4 cm");
            Assert.fail((String)"Expected exception not thrown!");
        }
        catch (QuantityConversionException qce) {
            Assert.assertEquals((Object)QuantityConversionException.Problem.UNPARSEABLE, (Object)qce.getProblem());
        }
    }

    @Test
    public void testInteractiveNoUnit() throws Exception {
        try {
            this.length.parseInteractive("1200" + this.decimalSep + "4");
            Assert.fail((String)"Expected exception not thrown!");
        }
        catch (QuantityConversionException qce) {
            Assert.assertEquals((Object)QuantityConversionException.Problem.NO_UNIT, (Object)qce.getProblem());
        }
    }

    @Test
    public void testInteractiveUnknownUnit() throws Exception {
        try {
            this.length.parseInteractive("1200" + this.decimalSep + "4 a");
            Assert.fail((String)"Expected exception not thrown!");
        }
        catch (QuantityConversionException qce) {
            Assert.assertEquals((Object)QuantityConversionException.Problem.UNKNOWN_UNIT, (Object)qce.getProblem());
        }
    }

    public static void assertNearlySame(IQuantity expected, IQuantity actual) {
        AdHocQuantityTest.assertNearlySame(null, expected, actual);
    }

    public static void assertNearlySame(String message, IQuantity expected, IQuantity actual) {
        if (expected.compareTo((Object)actual) == 0) {
            return;
        }
        double expectedNum = expected.doubleValueIn(actual.getUnit());
        double actualNum = actual.doubleValue();
        double ulp = Math.ulp(expectedNum);
        if (!(Math.abs(expectedNum - actualNum) <= Math.scalb(ulp, 2))) {
            AdHocQuantityTest.failNotEquals(message, expected, actual);
        }
    }

    public static void assertInteractiveRoundtrip(IQuantity quantity) throws QuantityConversionException {
        KindOfQuantity kind = quantity.getUnit().getContentType();
        String uiText = quantity.interactiveFormat();
        ITypedQuantity newQuantity = kind.parseInteractive(uiText);
        Assert.assertEquals((Object)quantity, (Object)newQuantity);
    }

    @Test
    public void testInteractiveLong() throws Exception {
        AdHocQuantityTest.assertInteractiveRoundtrip(this.a4width);
        Random rnd = new Random(17L);
        for (int i = 0; i < 1000; ++i) {
            ITypedQuantity length = this.um.quantity(rnd.nextLong());
            AdHocQuantityTest.assertInteractiveRoundtrip((IQuantity)length);
        }
    }

    @Test
    public void testInteractiveDouble() throws Exception {
        AdHocQuantityTest.assertInteractiveRoundtrip(this.a4length);
        Random rnd = new Random(17L);
        for (int i = 0; i < 1000; ++i) {
            ITypedQuantity length = this.um.quantity(rnd.nextDouble());
            AdHocQuantityTest.assertInteractiveRoundtrip((IQuantity)length);
        }
    }
}

