/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.item;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IStateful;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.PersistableItemFilter;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.StateToolkit;

public class ItemFilterTest
extends MCTestCase {
    protected static final LinearUnit B = UnitLookup.BYTE;
    protected static final LinearUnit MB = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.MEBI);
    protected static final boolean VERBOSE = Boolean.getBoolean("org.openjdk.jmc.common.test.item.verbose");
    protected static final IAttribute<IQuantity> LOWFIELD_ATTRIBUTE = Attribute.attr((String)"lowfield", null, (ContentType)UnitLookup.MEMORY);
    protected static final IAttribute<IQuantity> HIGHFIELD_ATTRIBUTE = Attribute.attr((String)"highfield", null, (ContentType)UnitLookup.MEMORY);
    protected static final IAttribute<IQuantity> RANGEFIELD_ATTRIBUTE = Attribute.attr((String)"rangefield", null, (ContentType)UnitLookup.MEMORY);
    protected static final IAttribute<IQuantity> MAGICFIELD_ATTRIBUTE = Attribute.attr((String)"magicfield", null, (ContentType)UnitLookup.MEMORY);
    protected static final IAttribute<IQuantity> SIZE_ATTRIBUTE = Attribute.attr((String)"size", null, (ContentType)UnitLookup.MEMORY);
    protected static final IAttribute<String> NAME_ATTRIBUTE = Attribute.attr((String)"name", null, (ContentType)UnitLookup.PLAIN_TEXT);

    @SafeVarargs
    protected static <T> Set<T> createSet(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    protected PersistableItemFilter createComparisionFilter() {
        IItemFilter lessFilter = ItemFilters.less(LOWFIELD_ATTRIBUTE, (Comparable)B.quantity(16L));
        IItemFilter moreFilter = ItemFilters.more(HIGHFIELD_ATTRIBUTE, (Comparable)MB.quantity(4L));
        IItemFilter xorFilter = ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.and((IItemFilter[])new IItemFilter[]{lessFilter, ItemFilters.not((IItemFilter)moreFilter)}), ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.not((IItemFilter)lessFilter), moreFilter})});
        IItemFilter rangeFilter = ItemFilters.interval(RANGEFIELD_ATTRIBUTE, (Comparable)B.quantity(32L), (boolean)true, (Comparable)B.quantity(64L), (boolean)false);
        return (PersistableItemFilter)ItemFilters.and((IItemFilter[])new IItemFilter[]{xorFilter, rangeFilter});
    }

    protected PersistableItemFilter createValueFilter() {
        IItemFilter exactFilter = ItemFilters.equals(SIZE_ATTRIBUTE, (Object)B.quantity(4711L));
        HashSet<ITypedQuantity> powerSet = new HashSet<ITypedQuantity>();
        for (int i = 128; i < 4096; i <<= 1) {
            powerSet.add(B.quantity((long)i));
        }
        IItemFilter powerFilter = ItemFilters.memberOf(SIZE_ATTRIBUTE, powerSet);
        IItemFilter sizeFilter = ItemFilters.or((IItemFilter[])new IItemFilter[]{exactFilter, powerFilter});
        IItemFilter trustedFilter = ItemFilters.memberOf(NAME_ATTRIBUTE, ItemFilterTest.createSet("Alice", "Bob", "Carol", "Dave"));
        IItemFilter untrustedFilter = ItemFilters.equals(NAME_ATTRIBUTE, (Object)"Eve");
        IItemFilter trustFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{trustedFilter, ItemFilters.not((IItemFilter)untrustedFilter)});
        return (PersistableItemFilter)ItemFilters.or((IItemFilter[])new IItemFilter[]{sizeFilter, trustFilter});
    }

    protected PersistableItemFilter createTypeFilter() {
        IItemFilter fieldFilter = ItemFilters.hasAttribute(MAGICFIELD_ATTRIBUTE);
        IItemFilter oneTypeFilter = ItemFilters.type((String)"onetype");
        IItemFilter someTypeFilter = ItemFilters.type(ItemFilterTest.createSet("the-A-type", "the-B-type"));
        return (PersistableItemFilter)ItemFilters.and((IItemFilter[])new IItemFilter[]{fieldFilter, oneTypeFilter, someTypeFilter});
    }

    protected PersistableItemFilter createFilter() {
        return (PersistableItemFilter)ItemFilters.and((IItemFilter[])new IItemFilter[]{this.createComparisionFilter(), this.createValueFilter(), this.createTypeFilter()});
    }

    protected String toString(IItemFilter filter) throws Exception {
        IWritableState writableState = StateToolkit.createWriter((String)"filter");
        ((PersistableItemFilter)filter).saveTo(writableState);
        return writableState.toString();
    }

    protected void assertPersists(IItemFilter filter) throws Exception {
        String document = StateToolkit.toXMLString((IStateful)((PersistableItemFilter)filter));
        if (VERBOSE) {
            System.out.println(document);
        }
        IItemFilter restoredFilter = PersistableItemFilter.readFrom((IState)StateToolkit.fromXMLString((String)document));
        if (VERBOSE) {
            System.out.println("---");
            System.out.println(this.toString(restoredFilter));
        }
        Assert.assertEquals((Object)this.toString(filter), (Object)this.toString(restoredFilter));
    }

    @Test
    public void testPersistingComparisions() throws Exception {
        this.assertPersists((IItemFilter)this.createComparisionFilter());
    }

    @Test
    public void testPersistingValues() throws Exception {
        this.assertPersists((IItemFilter)this.createValueFilter());
    }

    @Test
    public void testPersistingTypes() throws Exception {
        this.assertPersists((IItemFilter)this.createTypeFilter());
    }

    @Test
    public void testPersistingValid() throws Exception {
        this.assertPersists((IItemFilter)this.createFilter());
    }
}

