/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.item;

import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.test.mock.item.MockAggregators;
import org.openjdk.jmc.common.test.mock.item.MockAttributes;
import org.openjdk.jmc.common.test.mock.item.MockCollections;
import org.openjdk.jmc.common.unit.IQuantity;

public class AggregatorTest
extends MCTestCase {
    private static final double EPSILON = 1.0E-9;

    @Test
    public void testSumAggregator() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(400, 999.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.SUM);
        Assert.assertEquals((double)195905.039483473, (double)aggregate.doubleValue(), (double)1.0E-9);
    }

    @Test
    public void testVarianceAggregator() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(400, 999.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.VARIANCE);
        Assert.assertEquals((double)74963.393247156, (double)aggregate.doubleValue(), (double)1.0E-9);
    }

    @Test
    public void testVariancepAggregator() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(400, 999.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.VARIANCEP);
        Assert.assertEquals((double)74775.9847640378, (double)aggregate.doubleValue(), (double)1.0E-9);
    }

    @Test
    public void testStddevAggregator() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(400, 999.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.STDDEV);
        Assert.assertEquals((double)273.794436114, (double)aggregate.doubleValue(), (double)1.0E-9);
    }

    @Test
    public void testStddevpAggregator() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(400, 999.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.STDDEVP);
        Assert.assertEquals((double)273.451978899473, (double)aggregate.doubleValue(), (double)1.0E-9);
    }

    @Test
    public void testVarianceAggregetorZeroElement() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(0, 1.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.VARIANCE);
        Assert.assertNull((Object)aggregate);
    }

    @Test
    public void testVariancepAggregetorZeroElement() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(0, 1.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.VARIANCEP);
        Assert.assertNull((Object)aggregate);
    }

    @Test
    public void testStddevAggregetorZeroElement() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(0, 1.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.STDDEV);
        Assert.assertNull((Object)aggregate);
    }

    @Test
    public void testStddevpAggregetorZeroElement() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(0, 1.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.STDDEVP);
        Assert.assertNull((Object)aggregate);
    }

    @Test
    public void testVarianceAggregetorOneElement() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(1, 999.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.VARIANCE);
        Assert.assertNull((Object)aggregate);
    }

    @Test
    public void testVariancepAggregetorOneElement() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(1, 999.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.VARIANCEP);
        Assert.assertEquals((double)aggregate.doubleValue(), (double)0.0, (double)1.0E-9);
    }

    @Test
    public void testStddevAggregatorOneElement() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(1, 999.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.STDDEV);
        Assert.assertNull((Object)aggregate);
    }

    @Test
    public void testStddevpAggregetorOneElement() {
        IItemCollection mockDoubleCollection = MockCollections.getNumberCollection(MockCollections.generateNumberArray(1, 999.0));
        IQuantity aggregate = (IQuantity)mockDoubleCollection.getAggregate(MockAggregators.STDDEVP);
        Assert.assertEquals((double)aggregate.doubleValue(), (double)0.0, (double)1.0E-9);
    }

    @Test
    public void testAdvancedMinAggregator() {
        IItemCollection mockCollection = MockCollections.getNumberCollection(new Number[]{101, 10, 135, 10});
        Aggregators.AdvancedMinAggregator advancedMinAggregator = new Aggregators.AdvancedMinAggregator("MinMock", "Should return the first number", MockAttributes.DOUBLE_VALUE, MockAttributes.INDEX_VALUE);
        IQuantity aggregate = (IQuantity)mockCollection.getAggregate((IAggregator)advancedMinAggregator);
        Assert.assertEquals((double)101.0, (double)aggregate.doubleValue(), (double)1.0E-9);
    }

    @Test
    public void testAdvancedMaxAggregator() {
        IItemCollection mockCollection = MockCollections.getNumberCollection(new Number[]{101, 10, 135, 10});
        Aggregators.AdvancedMaxAggregator advancedMinAggregator = new Aggregators.AdvancedMaxAggregator("MaxMock", "Should return the last number", MockAttributes.DOUBLE_VALUE, MockAttributes.INDEX_VALUE);
        IQuantity aggregate = (IQuantity)mockCollection.getAggregate((IAggregator)advancedMinAggregator);
        Assert.assertEquals((double)10.0, (double)aggregate.doubleValue(), (double)1.0E-9);
    }

    @Test
    public void testAdvancedMaxAggregatorNullOnTheWay() {
        IItemCollection mockCollection = MockCollections.getNumberCollection(new Number[]{101, null, 135, 10});
        Aggregators.AdvancedMaxAggregator advancedMinAggregator = new Aggregators.AdvancedMaxAggregator("MaxMock", "Should return the last number", MockAttributes.DOUBLE_VALUE, MockAttributes.INDEX_VALUE);
        IQuantity aggregate = (IQuantity)mockCollection.getAggregate((IAggregator)advancedMinAggregator);
        Assert.assertEquals((double)10.0, (double)aggregate.doubleValue(), (double)1.0E-9);
    }

    @Test
    public void testAdvancedMaxAggregatorLastElementNull() {
        IItemCollection mockCollection = MockCollections.getNumberCollection(new Number[]{101, null, 135, null});
        Aggregators.AdvancedMaxAggregator advancedMinAggregator = new Aggregators.AdvancedMaxAggregator("MaxMock", "Should return the last number", MockAttributes.DOUBLE_VALUE, MockAttributes.INDEX_VALUE);
        try {
            mockCollection.getAggregate((IAggregator)advancedMinAggregator);
            Assert.fail((String)"You really should never get here!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        System.out.println(MockCollections.generateFullPrecisionString(MockCollections.generateNumberArray(400, 999.0)));
    }
}

