/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentConfigurationImpl;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.DebugUtils;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.targetplatform.DefaultDependencyArtifacts;
import org.eclipse.tycho.core.resolver.DefaultDependencyResolverFactory;
import org.eclipse.tycho.core.resolver.DefaultTargetPlatformConfigurationReader;
import org.eclipse.tycho.core.resolver.shared.OptionalResolutionAction;
import org.eclipse.tycho.core.resolver.shared.PlatformPropertiesUtils;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.resolver.TychoResolver;

@Component(role=TychoResolver.class)
public class DefaultTychoResolver
implements TychoResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private DefaultTargetPlatformConfigurationReader configurationReader;
    @Requirement
    private DefaultDependencyResolverFactory dependencyResolverLocator;
    @Requirement(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Requirement
    private ToolchainManager toolchainManager;
    public static final String TYCHO_ENV_OSGI_WS = "tycho.env.osgi.ws";
    public static final String TYCHO_ENV_OSGI_OS = "tycho.env.osgi.os";
    public static final String TYCHO_ENV_OSGI_ARCH = "tycho.env.osgi.arch";
    public static final String PROPERTY_PREFIX = "pom.model.property.";

    public void setupProject(MavenSession session, MavenProject project, ReactorProject reactorProject) {
        AbstractTychoProject dr = (AbstractTychoProject)this.projectTypes.get(project.getPackaging());
        if (dr == null) {
            return;
        }
        if (reactorProject.getContextValue(TychoConstants.CTX_MERGED_PROPERTIES) != null) {
            return;
        }
        dr.setupProject(session, project);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.putAll((Map<?, ?>)session.getSystemProperties());
        properties.putAll((Map<?, ?>)session.getUserProperties());
        reactorProject.setContextValue(TychoConstants.CTX_MERGED_PROPERTIES, (Object)properties);
        this.setTychoEnvironmentProperties(properties, project);
        this.setBuildProperties(project);
        TargetPlatformConfiguration configuration = this.configurationReader.getTargetPlatformConfiguration(session, project);
        reactorProject.setContextValue(TychoConstants.CTX_TARGET_PLATFORM_CONFIGURATION, (Object)configuration);
        ExecutionEnvironmentConfigurationImpl eeConfiguration = new ExecutionEnvironmentConfigurationImpl(this.logger, !configuration.isResolveWithEEConstraints(), this.toolchainManager, session);
        dr.readExecutionEnvironmentConfiguration(reactorProject, session, eeConfiguration);
        reactorProject.setContextValue(TychoConstants.CTX_EXECUTION_ENVIRONMENT_CONFIGURATION, (Object)eeConfiguration);
        DependencyResolver resolver = this.dependencyResolverLocator.lookupDependencyResolver(project);
        resolver.setupProjects(session, project, reactorProject);
    }

    public void resolveProject(MavenSession session, MavenProject project, List<ReactorProject> reactorProjects) {
        AbstractTychoProject dr = (AbstractTychoProject)this.projectTypes.get(project.getPackaging());
        if (dr == null) {
            return;
        }
        DependencyResolver resolver = this.dependencyResolverLocator.lookupDependencyResolver(project);
        this.logger.info("Computing target platform for " + project);
        TargetPlatform preliminaryTargetPlatform = resolver.computePreliminaryTargetPlatform(session, project, reactorProjects);
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration(reactorProject);
        final DependencyResolverConfiguration resolverConfiguration = configuration.getDependencyResolverConfiguration();
        this.logger.info("Resolving dependencies of " + project);
        DependencyArtifacts dependencyArtifacts = resolver.resolveDependencies(session, project, preliminaryTargetPlatform, reactorProjects, resolverConfiguration);
        if (this.logger.isDebugEnabled() && DebugUtils.isDebugEnabled(session, project)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Resolved target platform for ").append(project).append("\n");
            dependencyArtifacts.toDebugString(sb, "  ");
            this.logger.debug(sb.toString());
        }
        dr.setDependencyArtifacts(session, reactorProject, dependencyArtifacts);
        DependencyArtifacts testDependencyArtifacts = null;
        TychoProject tychoProjectType = this.projectTypes.get(project.getPackaging());
        if (tychoProjectType instanceof BundleProject) {
            final List<ArtifactKey> testDependencies = ((BundleProject)tychoProjectType).getExtraTestRequirements(reactorProject);
            if (!testDependencies.isEmpty()) {
                this.logger.info("Resolving test dependencies of " + project);
                DependencyResolverConfiguration testResolverConfiguration = new DependencyResolverConfiguration(){

                    @Override
                    public OptionalResolutionAction getOptionalResolutionAction() {
                        return resolverConfiguration.getOptionalResolutionAction();
                    }

                    @Override
                    public List<ArtifactKey> getExtraRequirements() {
                        ArrayList<ArtifactKey> res = new ArrayList<ArtifactKey>(resolverConfiguration.getExtraRequirements());
                        res.addAll(testDependencies);
                        return res;
                    }
                };
                testDependencyArtifacts = resolver.resolveDependencies(session, project, preliminaryTargetPlatform, reactorProjects, testResolverConfiguration);
            }
            dr.setTestDependencyArtifacts(session, reactorProject, Objects.requireNonNullElse(testDependencyArtifacts, new DefaultDependencyArtifacts()));
        }
        this.logger.info("Resolving class path of " + project);
        dr.resolveClassPath(session, project);
        resolver.injectDependenciesIntoMavenModel(project, dr, dependencyArtifacts, testDependencyArtifacts, this.logger);
        if (this.logger.isDebugEnabled() && DebugUtils.isDebugEnabled(session, project)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Injected dependencies for ").append(project.toString()).append("\n");
            for (Dependency dependency : project.getDependencies()) {
                sb.append("  ").append(dependency.toString());
            }
            this.logger.debug(sb.toString());
        }
    }

    protected void setTychoEnvironmentProperties(Properties properties, MavenProject project) {
        String arch = PlatformPropertiesUtils.getArch((Properties)properties);
        String os = PlatformPropertiesUtils.getOS((Properties)properties);
        String ws = PlatformPropertiesUtils.getWS((Properties)properties);
        project.getProperties().put(TYCHO_ENV_OSGI_WS, ws);
        project.getProperties().put(TYCHO_ENV_OSGI_OS, os);
        project.getProperties().put(TYCHO_ENV_OSGI_ARCH, arch);
    }

    protected void setBuildProperties(MavenProject project) {
        File buildPropertiesFile;
        File pomfile = project.getFile();
        if (pomfile != null && (buildPropertiesFile = new File(pomfile.getParentFile(), "build.properties")).isFile() && buildPropertiesFile.length() > 0L) {
            Properties buildProperties = new Properties();
            try {
                try (FileInputStream stream = new FileInputStream(buildPropertiesFile);){
                    buildProperties.load(stream);
                }
                Properties projectProperties = project.getProperties();
                buildProperties.stringPropertyNames().forEach(key -> {
                    if (key.startsWith(PROPERTY_PREFIX)) {
                        projectProperties.setProperty(key.substring(PROPERTY_PREFIX.length()), buildProperties.getProperty((String)key));
                    }
                });
            }
            catch (IOException e) {
                this.logger.warn("reading build.properties from project " + project.getName() + " failed", (Throwable)e);
            }
        }
    }
}

