/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.osgi.adapters.MavenReactorProjectIdentities;

public class DefaultReactorProject
implements ReactorProject {
    private static final String CTX_REACTOR_PROJECT = "tycho.reactor-project";
    private static final String CTX_DEPENDENCY_METADATA_PREFIX = "tycho.dependency-metadata-";
    public final MavenProject project;
    private final Map<String, Object> context = new ConcurrentHashMap<String, Object>();

    public DefaultReactorProject(MavenProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.project = project;
    }

    public static ReactorProject adapt(MavenProject project) {
        if (project == null) {
            return null;
        }
        ReactorProject reactorProject = (ReactorProject)project.getContextValue(CTX_REACTOR_PROJECT);
        if (reactorProject == null) {
            reactorProject = new DefaultReactorProject(project);
            project.setContextValue(CTX_REACTOR_PROJECT, (Object)reactorProject);
        }
        return reactorProject;
    }

    public static List<ReactorProject> adapt(MavenSession session) {
        ArrayList<ReactorProject> result = new ArrayList<ReactorProject>();
        for (MavenProject project : session.getProjects()) {
            result.add(DefaultReactorProject.adapt(project));
        }
        return result;
    }

    public boolean sameProject(Object otherProject) {
        return this.project.equals(otherProject);
    }

    public File getBasedir() {
        return this.project.getBasedir();
    }

    public String getPackaging() {
        return this.project.getPackaging();
    }

    public String getGroupId() {
        return this.project.getGroupId();
    }

    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    public String getVersion() {
        return this.project.getVersion();
    }

    public ReactorProjectIdentities getIdentities() {
        return new MavenReactorProjectIdentities(this.project);
    }

    public BuildOutputDirectory getBuildDirectory() {
        return new BuildOutputDirectory(new File(this.project.getBuild().getDirectory()), new File(this.project.getBuild().getOutputDirectory()), new File(this.project.getBuild().getTestOutputDirectory()));
    }

    public File getArtifact() {
        Artifact artifact = this.project.getArtifact();
        return artifact != null ? artifact.getFile() : null;
    }

    public File getArtifact(String artifactClassifier) {
        Artifact artifact = null;
        if (artifactClassifier == null) {
            artifact = this.project.getArtifact();
        } else {
            for (Artifact attached : this.project.getAttachedArtifacts()) {
                if (!artifactClassifier.equals(attached.getClassifier())) continue;
                artifact = attached;
                break;
            }
        }
        return artifact != null ? artifact.getFile() : null;
    }

    public Object getContextValue(String key) {
        Object value = this.context.get(key);
        return value != null ? value : this.project.getContextValue(key);
    }

    public void setContextValue(String key, Object value) {
        Objects.requireNonNull(key, "key can't be null");
        if (value == null) {
            this.context.remove(key);
        } else {
            this.context.put(key, value);
        }
    }

    public void setDependencyMetadata(IDependencyMetadata.DependencyMetadataType type, Collection<?> units) {
        this.setContextValue(DefaultReactorProject.getDependencyMetadataKey(type), units);
    }

    public Set<?> getDependencyMetadata() {
        LinkedHashSet result = new LinkedHashSet(this.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.SEED));
        result.addAll(this.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.RESOLVE));
        return result;
    }

    public Set<?> getDependencyMetadata(IDependencyMetadata.DependencyMetadataType type) {
        return Objects.requireNonNullElse((Set)this.getContextValue(DefaultReactorProject.getDependencyMetadataKey(type)), Collections.emptySet());
    }

    private static String getDependencyMetadataKey(IDependencyMetadata.DependencyMetadataType type) {
        return CTX_DEPENDENCY_METADATA_PREFIX + type.name().toLowerCase();
    }

    public String getBuildQualifier() {
        String version = (String)this.project.getProperties().get("buildQualifier");
        if (version != null) {
            return version;
        }
        throw new IllegalStateException("Project " + this.getId() + " does not have a build qualifier");
    }

    public String getExpandedVersion() {
        String version = (String)this.project.getProperties().get("qualifiedVersion");
        if (version != null) {
            return version;
        }
        throw new IllegalStateException("Project " + this.getId() + " does not have an expanded version");
    }

    public String getId() {
        return this.project.getId();
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultReactorProject)) {
            return false;
        }
        DefaultReactorProject other = (DefaultReactorProject)obj;
        return this.project.equals((Object)other.project);
    }

    public String toString() {
        return this.project.toString();
    }

    public String getName() {
        return this.project.getName();
    }
}

