/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.tycho.core.maven.TychoInterpolator;
import org.eclipse.tycho.core.shared.BuildProperties;
import org.eclipse.tycho.core.shared.BuildPropertiesImpl;
import org.eclipse.tycho.core.shared.BuildPropertiesParser;
import org.eclipse.tycho.core.utils.MavenSessionUtils;

@Component(role=BuildPropertiesParser.class)
public class BuildPropertiesParserImpl
implements BuildPropertiesParser,
Disposable {
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private Logger logger;
    private final Map<String, BuildPropertiesImpl> cache = new HashMap<String, BuildPropertiesImpl>();

    public BuildPropertiesParserImpl() {
    }

    protected BuildPropertiesParserImpl(LegacySupport legacySupport, Logger logger) {
        this.legacySupport = legacySupport;
        this.logger = logger;
    }

    public BuildProperties parse(File baseDir) {
        File propsFile = new File(baseDir, "build.properties");
        long lastModified = propsFile.lastModified();
        String filePath = propsFile.getAbsolutePath();
        BuildPropertiesImpl buildProperties = this.cache.get(filePath);
        if (buildProperties == null || lastModified > buildProperties.getTimestamp()) {
            Properties properties = BuildPropertiesParserImpl.readProperties(propsFile);
            this.interpolate(properties, baseDir);
            buildProperties = new BuildPropertiesImpl(properties, lastModified);
            this.cache.put(filePath, buildProperties);
        }
        return buildProperties;
    }

    public void dispose() {
        this.cache.clear();
    }

    protected static Properties readProperties(File propsFile) {
        Properties properties = new Properties();
        if (propsFile.canRead()) {
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(propsFile);
                    properties.load(is);
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    protected void interpolate(Properties properties, File baseDir) {
        if (properties.isEmpty()) {
            return;
        }
        MavenSession mavenSession = this.legacySupport.getSession();
        if (mavenSession == null) {
            this.logger.warn("No maven session available, values in the build.properties will not be interpolated!");
            return;
        }
        MavenProject mavenProject = MavenSessionUtils.getMavenProject(mavenSession, baseDir);
        if (mavenProject == null) {
            this.logger.warn("No maven project found for baseDir '" + baseDir.getAbsolutePath() + "', values in the build.properties will not be interpolated!");
            return;
        }
        TychoInterpolator interpolator = new TychoInterpolator(mavenSession, mavenProject);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            entry.setValue(interpolator.interpolate((String)entry.getValue()));
        }
    }
}

