/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.ee.UnknownEnvironmentException;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.osgi.framework.BundleActivator;

public class ExecutionEnvironmentUtils {
    private static final Map<String, Properties> profilesProperties = ExecutionEnvironmentUtils.fillEnvironmentsMap();
    private static final Map<String, StandardExecutionEnvironment> executionEnvironmentsMap = new ConcurrentHashMap<String, StandardExecutionEnvironment>(profilesProperties.size(), 1.0f);

    private static Map<String, Properties> fillEnvironmentsMap() {
        Properties listProps = ExecutionEnvironmentUtils.readProperties(ExecutionEnvironmentUtils.findInSystemBundle("profile.list"));
        ArrayList<String> profileFiles = new ArrayList<String>(Arrays.asList(listProps.getProperty("java.profiles").split(",")));
        profileFiles.add("JavaSE-11.profile");
        profileFiles.add("JavaSE-15.profile");
        profileFiles.add("JavaSE-16.profile");
        profileFiles.add("JavaSE-17.profile");
        LinkedHashMap<String, Properties> envMap = new LinkedHashMap<String, Properties>(profileFiles.size(), 1.0f);
        for (String profileFile : profileFiles) {
            Properties props = ExecutionEnvironmentUtils.readProperties(ExecutionEnvironmentUtils.findInSystemBundle(profileFile.trim()));
            envMap.put(props.getProperty("osgi.java.profile.name").trim(), props);
        }
        return envMap;
    }

    private static Properties readProperties(URL url) {
        Properties listProps = new Properties();
        InputStream stream = null;
        try {
            stream = url.openStream();
            listProps.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return listProps;
    }

    public static StandardExecutionEnvironment getExecutionEnvironment(String profileName, ToolchainManager manager, MavenSession session, Logger logger) throws UnknownEnvironmentException {
        if (!profilesProperties.containsKey(profileName)) {
            throw new UnknownEnvironmentException(profileName);
        }
        return executionEnvironmentsMap.computeIfAbsent(profileName, name -> {
            List toolchains = manager != null && session != null ? manager.getToolchains(session, "jdk", Collections.singletonMap("id", profileName)) : Collections.emptyList();
            return new StandardExecutionEnvironment(profilesProperties.get(name), toolchains.isEmpty() ? null : (Toolchain)toolchains.iterator().next(), logger);
        });
    }

    public static List<String> getProfileNames() {
        return new ArrayList<String>(profilesProperties.keySet());
    }

    public static void applyProfileProperties(Properties properties, ExecutionEnvironment executionEnvironment) {
        String systemCapabilities;
        String ee;
        String systemExports = properties.getProperty("org.osgi.framework.system.packages");
        if (systemExports == null && (systemExports = executionEnvironment.getSystemPackages().stream().map(ExecutionEnvironment.SystemPackageEntry::toPackageSpecifier).collect(Collectors.joining(","))) != null && !systemExports.isEmpty()) {
            properties.put("org.osgi.framework.system.packages", systemExports);
        }
        String type = properties.getProperty("osgi.java.profile.bootdelegation");
        Properties profileProps = executionEnvironment.getProfileProperties();
        String profileBootDelegation = profileProps.getProperty("org.osgi.framework.bootdelegation");
        if ("override".equals(type)) {
            if (profileBootDelegation == null) {
                properties.remove("org.osgi.framework.bootdelegation");
            } else {
                properties.put("org.osgi.framework.bootdelegation", profileBootDelegation);
            }
        } else if ("none".equals(type)) {
            properties.remove("org.osgi.framework.bootdelegation");
        }
        if (properties.getProperty("org.osgi.framework.executionenvironment") == null && (ee = profileProps.getProperty("org.osgi.framework.executionenvironment", profileProps.getProperty("osgi.java.profile.name"))) != null) {
            properties.put("org.osgi.framework.executionenvironment", ee);
        }
        if (properties.getProperty("org.osgi.framework.system.capabilities") == null && (systemCapabilities = profileProps.getProperty("org.osgi.framework.system.capabilities")) != null) {
            properties.put("org.osgi.framework.system.capabilities", systemCapabilities);
        }
    }

    private static URL findInSystemBundle(String entry) {
        ClassLoader loader = BundleActivator.class.getClassLoader();
        return loader == null ? ClassLoader.getSystemResource(entry) : loader.getResource(entry);
    }
}

