/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.mvn;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.SAXException;

class PropertyReplacer {
    PropertyReplacer() {
    }

    public void replace(Log log, NSDictionary dictionary, Properties properties) throws Exception {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value != null && !value.isEmpty()) {
                this.putValue(dictionary, key, value);
                log.info((CharSequence)MessageFormat.format("Setting property ''{0}'' to ''{1}''", key, value));
                continue;
            }
            dictionary.remove(key);
            log.info((CharSequence)MessageFormat.format("Removing property ''{0}''", key));
        }
    }

    private void putValue(NSDictionary dictionary, String key, String value) throws IOException, PropertyListFormatException, SAXException, ParserConfigurationException, ParseException {
        boolean isNSObject;
        boolean isArray = value.charAt(0) == '[';
        boolean bl = isNSObject = value.charAt(0) == '<';
        if (isArray) {
            String[] values = value.substring(1, value.length() - 1).split(",");
            NSArray array = new NSArray(values.length);
            for (int ii = 0; ii < values.length; ++ii) {
                array.setValue(ii, (Object)new NSString(values[ii]));
            }
            dictionary.put(key, (NSObject)array);
        } else if (isNSObject) {
            NSObject object = PropertyListParser.parse((byte[])("<plist>" + value + "</plist>").getBytes());
            dictionary.put(key, object);
        } else {
            dictionary.put(key, (NSObject)new NSString(value));
        }
    }
}

