/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target.ee;

import java.util.Collection;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.p2.target.ee.AllKnownEEsResolutionHints;
import org.eclipse.tycho.p2.target.ee.CustomEEResolutionHandler;
import org.eclipse.tycho.p2.target.ee.NoExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.target.ee.StandardEEResolutionHandler;
import org.eclipse.tycho.p2.target.ee.StandardEEResolutionHints;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;

public abstract class ExecutionEnvironmentResolutionHandler {
    private final ExecutionEnvironmentResolutionHints resolutionHints;

    public static ExecutionEnvironmentResolutionHandler adapt(ExecutionEnvironmentConfiguration eeConfiguration) {
        if (eeConfiguration.ignoreExecutionEnvironment()) {
            return new StandardEEResolutionHandler(NoExecutionEnvironmentResolutionHints.INSTANCE);
        }
        if (eeConfiguration.isIgnoredByResolver()) {
            return new StandardEEResolutionHandler(new AllKnownEEsResolutionHints(eeConfiguration.getAllKnownEEs()));
        }
        if (eeConfiguration.isCustomProfile()) {
            return new CustomEEResolutionHandler(eeConfiguration);
        }
        return new StandardEEResolutionHandler(new StandardEEResolutionHints(eeConfiguration.getFullSpecification()));
    }

    public ExecutionEnvironmentResolutionHandler(ExecutionEnvironmentResolutionHints resolutionHints) {
        this.resolutionHints = resolutionHints;
    }

    public final ExecutionEnvironmentResolutionHints getResolutionHints() {
        return this.resolutionHints;
    }

    public abstract void readFullSpecification(Collection<IInstallableUnit> var1);
}

