/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.io.IOException;
import java.io.Reader;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.markup.XmlMarkup;
import org.apache.maven.doxia.parser.AbstractParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractXmlParser
extends AbstractParser
implements XmlMarkup {
    public void parse(Reader source, Sink sink) throws ParseException {
        try {
            MXParser parser = new MXParser();
            parser.setInput(source);
            this.parseXml((XmlPullParser)parser, sink);
        }
        catch (XmlPullParserException ex) {
            throw new ParseException("Error parsing the model: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (MacroExecutionException ex) {
            throw new ParseException("Macro execution failed: " + ex.getMessage(), ex);
        }
    }

    public final int getType() {
        return 2;
    }

    private void parseXml(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                this.handleStartTag(parser, sink);
            } else if (eventType == 3) {
                this.handleEndTag(parser, sink);
            } else if (eventType == 4) {
                this.handleText(parser, sink);
            } else if (eventType == 5 || eventType == 9 || eventType == 6) {
                // empty if block
            }
            try {
                eventType = parser.next();
            }
            catch (IOException io) {
                throw new XmlPullParserException("IOException: " + io.getMessage(), parser, (Throwable)io);
            }
        }
    }

    protected abstract void handleStartTag(XmlPullParser var1, Sink var2) throws XmlPullParserException, MacroExecutionException;

    protected abstract void handleEndTag(XmlPullParser var1, Sink var2) throws XmlPullParserException, MacroExecutionException;

    protected abstract void handleText(XmlPullParser var1, Sink var2) throws XmlPullParserException;
}

