/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.unit;

import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.test.unit.AdHocQuantityTest;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;

public class ContentTypeTest
extends MCTestCase {
    public static void assertContains(String expectedSubStr, String actual) {
        if (!actual.contains(expectedSubStr)) {
            Assert.fail((String)("expected to contain:<" + expectedSubStr + "> did not:<" + actual + ">"));
        }
    }

    public static void assertNotContain(String unexpectedSubStr, String actual) {
        if (actual.contains(unexpectedSubStr)) {
            Assert.fail((String)("didn't expect to contain:<" + unexpectedSubStr + "> did:<" + actual + ">"));
        }
    }

    @Test
    public void testTimestampInteractive() throws Exception {
        for (IUnit unit : UnitLookup.TIMESTAMP.getAllUnits()) {
            IQuantity quantity = unit.quantity(-49379812088L);
            AdHocQuantityTest.assertInteractiveRoundtrip(quantity);
            quantity = unit.quantity(4937981208836185L);
            AdHocQuantityTest.assertInteractiveRoundtrip(quantity);
        }
    }

    @Test
    public void testTimestampMilliRangeFormat() throws Exception {
        IRange range = QuantityRange.createWithEnd((IQuantity)UnitLookup.EPOCH_MS.quantity(4200000000123L), (IQuantity)UnitLookup.EPOCH_MS.quantity(4200000000999L));
        ContentTypeTest.assertContains("999", range.displayUsing("auto"));
        ContentTypeTest.assertContains("999", range.displayUsing("exact"));
        ContentTypeTest.assertContains("999", range.displayUsing("verbose"));
    }

    @Test
    public void testTimestampNanoRangeFormat() throws Exception {
        IRange range = QuantityRange.createWithEnd((IQuantity)UnitLookup.EPOCH_NS.quantity(4200000000123000000L), (IQuantity)UnitLookup.EPOCH_NS.quantity(4200000000999999999L));
        ContentTypeTest.assertContains("999", range.displayUsing("auto"));
        ContentTypeTest.assertContains("999", range.displayUsing("exact"));
        ContentTypeTest.assertContains("999", range.displayUsing("verbose"));
    }

    @Test
    public void testTimestampPersisted() throws Exception {
        for (IUnit unit : UnitLookup.TIMESTAMP.getAllUnits()) {
            IQuantity quantity = unit.quantity(-4937981208836185383L);
            AdHocQuantityTest.assertPersistedRoundtrip(quantity);
            quantity = unit.quantity(4937981208836185383L);
            AdHocQuantityTest.assertPersistedRoundtrip(quantity);
        }
    }

    @Test
    public void testTimeSpanUnits() {
        for (IUnit unit : UnitLookup.TIMESPAN.getAllUnits()) {
            IQuantity quantity = unit.quantity(17L);
            Assert.assertTrue((boolean)quantity.toString().contains("17"));
        }
    }

    @Test
    public void testTimeSpanFormatAlmostWeeks() {
        LinearUnit days = UnitLookup.TIMESPAN.getUnit("d");
        ITypedQuantity almost2wk = days.quantity(13.5);
        String dispStr = almost2wk.displayUsing("auto");
        ContentTypeTest.assertContains("2", dispStr);
        ContentTypeTest.assertNotContain("14", dispStr);
        ContentTypeTest.assertNotContain("13", dispStr);
        ContentTypeTest.assertNotContain("12", dispStr);
    }

    @Test
    public void testTimeSpanFormatAlmostWeeksNeg() {
        LinearUnit days = UnitLookup.TIMESPAN.getUnit("d");
        ITypedQuantity almost2wk = days.quantity(-13.5);
        String dispStr = almost2wk.displayUsing("auto");
        ContentTypeTest.assertContains("2", dispStr);
        ContentTypeTest.assertNotContain("14", dispStr);
        ContentTypeTest.assertNotContain("13", dispStr);
        ContentTypeTest.assertNotContain("12", dispStr);
    }

    @Test
    public void testTimeSpanFormatFewMinutes() {
        LinearUnit seconds = UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.NONE);
        ITypedQuantity fewMinutes = seconds.quantity(100L);
        String dispStr = fewMinutes.displayUsing("auto");
        ContentTypeTest.assertContains("1", dispStr);
        ContentTypeTest.assertContains("40", dispStr);
        ContentTypeTest.assertNotContain("20", dispStr);
    }

    @Test
    public void testTimeSpanFormatFewMinutesNeg() {
        LinearUnit seconds = UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.NONE);
        ITypedQuantity fewMinutes = seconds.quantity(-100L);
        String dispStr = fewMinutes.displayUsing("auto");
        ContentTypeTest.assertContains("1", dispStr);
        ContentTypeTest.assertContains("40", dispStr);
        ContentTypeTest.assertNotContain("20", dispStr);
    }

    @Test
    public void testTimeSpanZeroDays() {
        LinearUnit days = UnitLookup.TIMESPAN.getUnit("d");
        ITypedQuantity noTime = days.quantity(0L);
        String dispStr = noTime.displayUsing("auto");
        ContentTypeTest.assertContains("0", dispStr);
    }

    @Test
    public void testTimeSpanZeroDaysNeg() {
        LinearUnit days = UnitLookup.TIMESPAN.getUnit("d");
        ITypedQuantity noTime = days.quantity(0L);
        String dispStr = noTime.displayUsing("auto");
        ContentTypeTest.assertContains("0", dispStr);
    }

    @Test
    public void testMicrosecondMu() {
        ContentTypeTest.assertNull(UnitLookup.getUnitOrNull((String)"timespan:\u03bcs"));
    }

    @Test
    public void testMicrosecondU() {
        LinearUnit us = UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.MICRO);
        Assert.assertEquals((Object)us, (Object)UnitLookup.getUnitOrNull((String)"timespan:us"));
    }

    @Test
    public void testPercentagePercent() {
        IUnit percent = UnitLookup.getUnitOrNull((String)"percentage:%");
        Assert.assertNotNull((Object)percent);
    }

    @Test
    public void testPercentageUnity() {
        IUnit unity = UnitLookup.getUnitOrNull((String)"percentage:");
        Assert.assertNotNull((Object)unity);
    }

    @Test
    public void testMemoryUnits() throws Exception {
        LinearUnit MiB = UnitLookup.MEMORY.getUnit("MiB");
        Assert.assertNotNull((Object)MiB);
        LinearUnit GiB = UnitLookup.MEMORY.getUnit("GiB");
        Assert.assertNotNull((Object)GiB);
        ITypedQuantity limit32bit = GiB.quantity(4L);
        Assert.assertEquals((long)4096L, (long)limit32bit.longValueIn((IUnit)MiB));
    }

    @Test
    public void testMemoryUnitsGenerally() throws Exception {
        LinearUnit MiB = (LinearUnit)UnitLookup.getUnitOrNull((String)"memory:MiB");
        Assert.assertNotNull((Object)MiB);
        LinearUnit GiB = (LinearUnit)UnitLookup.getUnitOrNull((String)"memory:GiB");
        Assert.assertNotNull((Object)GiB);
        ITypedQuantity limit32bit = GiB.quantity(4L);
        Assert.assertEquals((long)4096L, (long)limit32bit.longValueIn((IUnit)MiB));
    }

    @Test
    public void testBadMemoryUnits() throws Exception {
        ContentTypeTest.assertNull(UnitLookup.MEMORY.getUnit("MB"));
        ContentTypeTest.assertNull(UnitLookup.MEMORY.getUnit("GB"));
        ContentTypeTest.assertNull(UnitLookup.MEMORY.getUnit("KB"));
        ContentTypeTest.assertNull(UnitLookup.MEMORY.getUnit("kB"));
    }

    @Test
    public void testBadMemoryUnitsGenerally() throws Exception {
        ContentTypeTest.assertNull(UnitLookup.getUnitOrNull((String)"memory:MB"));
        ContentTypeTest.assertNull(UnitLookup.getUnitOrNull((String)"memory:GB"));
        ContentTypeTest.assertNull(UnitLookup.getUnitOrNull((String)"memory:KB"));
        ContentTypeTest.assertNull(UnitLookup.getUnitOrNull((String)"memory:kB"));
    }

    @Test
    public void testCustomUnitConversion() throws Exception {
        LinearKindOfQuantity memory = UnitLookup.MEMORY;
        ITypedQuantity unitBase = memory.parsePersisted("14075211111991929 TiB");
        LinearUnit customUnit = memory.makeCustomUnit(unitBase);
        ITypedQuantity quantity = customUnit.quantity(-690087618782632812L);
        ITypedQuantity wellKnown = memory.parsePersisted(quantity.persistableString());
        AdHocQuantityTest.assertNearlySame((IQuantity)wellKnown, (IQuantity)quantity);
        AdHocQuantityTest.assertNearlySame((IQuantity)quantity, (IQuantity)wellKnown);
    }

    @Test
    public void testPersistedQuantityInfinity() throws Exception {
        ITypedQuantity quantity = UnitLookup.TIMESPAN.parsePersisted("infinity");
        Assert.assertEquals((long)quantity.longValue(), (long)Long.MAX_VALUE);
    }
}

