/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test;

import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.unit.BinaryPrefix;

public class BinaryPrefixTest
extends MCTestCase {
    private void assertAlignmentLog2(int expectedLog2, long value) throws Exception {
        Assert.assertEquals((long)expectedLog2, (long)BinaryPrefix.getAlignmentLog2((long)value));
    }

    private void assertAlignmentLog2(int expectedLog2, double value) throws Exception {
        Assert.assertEquals((long)expectedLog2, (long)BinaryPrefix.getAlignmentLog2((double)value));
    }

    @Test
    public void testZero() {
        Assert.assertEquals((long)0L, (long)BinaryPrefix.getFloorLog1024((long)0L));
        Assert.assertEquals((Object)BinaryPrefix.NOBI, (Object)BinaryPrefix.getFloorPrefix((long)0L));
    }

    @Test
    public void testZeroDouble() {
        Assert.assertEquals((long)0L, (long)BinaryPrefix.getFloorLog1024((double)0.0));
        Assert.assertEquals((Object)BinaryPrefix.NOBI, (Object)BinaryPrefix.getFloorPrefix((double)0.0));
    }

    @Test
    public void testPositive() {
        int oldLog1024 = -1;
        BinaryPrefix oldPrefix = null;
        int i = 0;
        for (long val = 1L; val != 0L; val <<= 1) {
            int log1024 = BinaryPrefix.getFloorLog1024((long)val);
            BinaryPrefix prefix = BinaryPrefix.getFloorPrefix((long)val);
            if (i++ % 10 == 0) {
                BinaryPrefixTest.assertGreaterThan("For value " + val, oldLog1024, log1024);
                if (oldPrefix == null) {
                    Assert.assertNotNull((Object)prefix);
                } else {
                    BinaryPrefixTest.assertGreaterThan(oldPrefix, prefix);
                }
            } else {
                Assert.assertEquals((String)("For value " + val), (long)oldLog1024, (long)log1024);
                Assert.assertSame(oldPrefix, (Object)prefix);
            }
            oldLog1024 = log1024;
            oldPrefix = prefix;
        }
    }

    @Test
    public void testPositiveDouble() {
        int oldLog1024 = -1;
        BinaryPrefix oldPrefix = null;
        int i = 0;
        for (int powOf2 = 0; powOf2 < 90; ++powOf2) {
            double val = Math.scalb(1.0, powOf2);
            int log1024 = BinaryPrefix.getFloorLog1024((double)val);
            BinaryPrefix prefix = BinaryPrefix.getFloorPrefix((double)val);
            if (i++ % 10 == 0) {
                BinaryPrefixTest.assertGreaterThan("For value " + val, oldLog1024, log1024);
                if (oldPrefix == null) {
                    Assert.assertNotNull((Object)prefix);
                } else {
                    BinaryPrefixTest.assertGreaterThan(oldPrefix, prefix);
                }
            } else {
                Assert.assertEquals((String)("For value " + val), (long)oldLog1024, (long)log1024);
                Assert.assertSame(oldPrefix, (Object)prefix);
            }
            oldLog1024 = log1024;
            oldPrefix = prefix;
        }
    }

    @Test
    public void testNegative() {
        int oldLog1024 = -1;
        BinaryPrefix oldPrefix = null;
        int i = 0;
        for (long val = -1L; val != 0L; val <<= 1) {
            int log1024 = BinaryPrefix.getFloorLog1024((long)val);
            BinaryPrefix prefix = BinaryPrefix.getFloorPrefix((long)val);
            if (i++ % 10 == 0) {
                BinaryPrefixTest.assertGreaterThan("For value " + val, oldLog1024, log1024);
                if (oldPrefix == null) {
                    Assert.assertNotNull((Object)prefix);
                } else {
                    BinaryPrefixTest.assertGreaterThan(oldPrefix, prefix);
                }
            } else {
                Assert.assertEquals((String)("For value " + val), (long)oldLog1024, (long)log1024);
                Assert.assertSame(oldPrefix, (Object)prefix);
            }
            oldLog1024 = log1024;
            oldPrefix = prefix;
        }
    }

    @Test
    public void testNegativeDouble() {
        int oldLog1024 = -1;
        BinaryPrefix oldPrefix = null;
        int i = 0;
        for (int powOf2 = 0; powOf2 < 90; ++powOf2) {
            double val = -Math.scalb(1.0, powOf2);
            int log1024 = BinaryPrefix.getFloorLog1024((double)val);
            BinaryPrefix prefix = BinaryPrefix.getFloorPrefix((double)val);
            if (i++ % 10 == 0) {
                BinaryPrefixTest.assertGreaterThan("For value " + val, oldLog1024, log1024);
                if (oldPrefix == null) {
                    Assert.assertNotNull((Object)prefix);
                } else {
                    BinaryPrefixTest.assertGreaterThan(oldPrefix, prefix);
                }
            } else {
                Assert.assertEquals((String)("For value " + val), (long)oldLog1024, (long)log1024);
                Assert.assertSame(oldPrefix, (Object)prefix);
            }
            oldLog1024 = log1024;
            oldPrefix = prefix;
        }
    }

    @Test
    public void testBinaryLongAlignment() throws Exception {
        this.assertAlignmentLog2(0, 1L);
        this.assertAlignmentLog2(0, 17L);
        this.assertAlignmentLog2(0, 1027L);
        this.assertAlignmentLog2(1, 2L);
        this.assertAlignmentLog2(1, 42L);
        this.assertAlignmentLog2(1, 1030L);
        this.assertAlignmentLog2(2, 4L);
        this.assertAlignmentLog2(3, 8L);
        this.assertAlignmentLog2(4, 16L);
        this.assertAlignmentLog2(10, 1024L);
    }

    @Test
    public void testBinaryDoubleAlignment() throws Exception {
        this.assertAlignmentLog2(0, 1.0);
        this.assertAlignmentLog2(0, 17.0);
        this.assertAlignmentLog2(0, 1027.0);
        this.assertAlignmentLog2(1, 2.0);
        this.assertAlignmentLog2(1, 42.0);
        this.assertAlignmentLog2(1, 1030.0);
        this.assertAlignmentLog2(2, 4.0);
        this.assertAlignmentLog2(3, 8.0);
        this.assertAlignmentLog2(4, 16.0);
        this.assertAlignmentLog2(10, 1024.0);
        this.assertAlignmentLog2(-1, 0.5);
        this.assertAlignmentLog2(-1, 1.5);
        this.assertAlignmentLog2(-1, 17.5);
        this.assertAlignmentLog2(-1, 1.67772165E7);
        this.assertAlignmentLog2(-2, 0.25);
        this.assertAlignmentLog2(-2, 1.25);
        this.assertAlignmentLog2(-2, 17.25);
        this.assertAlignmentLog2(-2, 1.677721625E7);
    }
}

