/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.bundler.impl;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.reficio.p2.bundler.ArtifactBundler;
import org.reficio.p2.bundler.ArtifactBundlerInstructions;
import org.reficio.p2.bundler.ArtifactBundlerRequest;
import org.reficio.p2.bundler.impl.AquteHelper;
import org.reficio.p2.logger.Logger;
import org.reficio.p2.utils.BundleUtils;
import org.reficio.p2.utils.JarUtils;

public class AquteBundler
implements ArtifactBundler {
    public static final String ECLIPSE_SOURCE_BUNDLE = "Eclipse-SourceBundle";
    public static final String IMPLEMENTATION_TITLE = "Implementation-Title";
    public static final String SPECIFICATION_TITLE = "Specification-Title";
    public static final String MANIFEST_VERSION = "Manifest-Version";
    protected final BundleUtils bundleUtils = new BundleUtils();
    private final boolean pedantic;

    public AquteBundler(boolean pedantic) {
        this.pedantic = pedantic;
    }

    @Override
    public void execute(ArtifactBundlerRequest request, ArtifactBundlerInstructions instructions) {
        this.log().info("Executing Bundler:");
        try {
            this.doWrap(request, instructions);
            this.doSourceWrap(request, instructions);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while bundling jar or source: " + request.getBinaryInputFile().getName(), ex);
        }
    }

    private void doWrap(ArtifactBundlerRequest request, ArtifactBundlerInstructions instructions) throws Exception {
        this.prepareOutputFile(request.getBinaryOutputFile());
        if (request.isShouldBundleBinaryFile()) {
            this.log().info("\t [EXEC] " + request.getBinaryInputFile().getName());
            this.handleVanillaJarWrap(request, instructions);
        } else {
            this.log().info("\t [SKIP] " + request.getBinaryInputFile().getName());
            this.handleBundleJarWrap(request, instructions);
        }
    }

    private void prepareOutputFile(File file) {
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        try {
            if (!file.createNewFile()) {
                throw new RuntimeException("Cannot create output file " + file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create output file " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleVanillaJarWrap(ArtifactBundlerRequest request, ArtifactBundlerInstructions instructions) throws Exception {
        Analyzer analyzer = AquteHelper.buildAnalyzer(request, instructions, this.pedantic);
        try {
            this.populateJar(analyzer, request.getBinaryOutputFile());
            this.bundleUtils.reportErrors(analyzer);
            this.removeSignature(request.getBinaryOutputFile());
        }
        finally {
            analyzer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateJar(Analyzer analyzer, File outputFile) throws Exception {
        Jar jar = analyzer.getJar();
        jar.setManifest(analyzer.calcManifest());
        try {
            jar.write(outputFile);
        }
        finally {
            jar.close();
        }
    }

    private void removeSignature(File jar) {
        if (JarUtils.containsSignature(jar)) {
            this.log().info("\t [UNSIGN] " + jar.getName());
            JarUtils.removeSignature(jar);
        }
    }

    private void handleBundleJarWrap(ArtifactBundlerRequest request, ArtifactBundlerInstructions instructions) throws IOException {
        FileUtils.copyFile((File)request.getBinaryInputFile(), (File)request.getBinaryOutputFile());
        if (instructions.isSnapshot().booleanValue()) {
            JarUtils.adjustSnapshotOutputVersion(request.getBinaryInputFile(), request.getBinaryOutputFile(), instructions.getProposedVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSourceWrap(ArtifactBundlerRequest request, ArtifactBundlerInstructions instructions) throws Exception {
        if (request.getSourceInputFile() == null) {
            return;
        }
        this.log().info("\t [EXEC] " + request.getSourceInputFile().getName());
        String symbolicName = instructions.getSourceSymbolicName();
        String referencedBundleSymbolicName = instructions.getSymbolicName();
        String version = request.isShouldBundleBinaryFile() ? instructions.getVersion() : instructions.getProposedVersion();
        String name = instructions.getSourceName();
        Jar jar = new Jar(request.getSourceInputFile());
        try {
            Manifest manifest = this.getManifest(jar);
            this.decorateSourceManifest(manifest, name, referencedBundleSymbolicName, symbolicName, version);
            jar.setManifest(manifest);
            jar.write(request.getSourceOutputFile());
        }
        finally {
            jar.close();
        }
    }

    private Manifest getManifest(Jar jar) throws Exception {
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
        }
        return manifest;
    }

    private void decorateSourceManifest(Manifest manifest, String name, String refrencedBundleSymbolicName, String symbolicName, String version) {
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Bundle-SymbolicName", symbolicName);
        attributes.putValue(ECLIPSE_SOURCE_BUNDLE, refrencedBundleSymbolicName + ";version=\"" + version + "\";roots:=\".\"");
        attributes.putValue("Bundle-Version", version);
        attributes.putValue("Bundle-Localization", "plugin");
        attributes.putValue(MANIFEST_VERSION, "1.0");
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-Name", name);
        attributes.putValue(IMPLEMENTATION_TITLE, name);
        attributes.putValue(SPECIFICATION_TITLE, name);
        attributes.putValue("Tool", "p2-maven-plugin (reficio.org)");
    }

    private Logger log() {
        return Logger.getLog();
    }
}

