/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.spi.AbstractArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.ArtifactSinkException;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.ArtifactSinkFactory;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IArtifactSink;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IRawArtifactSink;

public abstract class AbstractArtifactRepository2
extends AbstractArtifactRepository
implements IRawArtifactProvider {
    protected AbstractArtifactRepository2(IProvisioningAgent agent, String name, String type, String version, URI location, String description, String provider, Map<String, String> properties) {
        super(agent, name, type, version, location, description, provider, properties);
    }

    protected abstract void internalAddDescriptor(IArtifactDescriptor var1);

    protected abstract void internalStore(IProgressMonitor var1);

    @Deprecated
    public final void addDescriptor(IArtifactDescriptor descriptor) {
        this.addDescriptor(descriptor, null);
    }

    @Deprecated
    public final void addDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        this.internalAddDescriptor(descriptor);
        this.internalStore(monitor);
    }

    @Deprecated
    public final void addDescriptors(IArtifactDescriptor[] descriptors) {
        this.addDescriptors(descriptors, null);
    }

    @Deprecated
    public final void addDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
            this.internalAddDescriptor(descriptor);
            ++n2;
        }
        this.internalStore(monitor);
    }

    protected abstract void internalRemoveDescriptor(IArtifactDescriptor var1);

    protected abstract void internalRemoveDescriptors(IArtifactDescriptor[] var1);

    protected abstract void internalRemoveDescriptors(IArtifactKey var1);

    protected abstract void internalRemoveDescriptors(IArtifactKey[] var1);

    protected abstract void internalRemoveAllDescriptors();

    public final void removeDescriptor(IArtifactDescriptor descriptor) {
        this.removeDescriptor(descriptor, null);
    }

    public final void removeDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        this.internalRemoveDescriptor(descriptor);
        this.internalStore(monitor);
    }

    public final void removeDescriptors(IArtifactDescriptor[] descriptors) {
        this.removeDescriptors(descriptors, null);
    }

    public final void removeDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        this.internalRemoveDescriptors(descriptors);
        this.internalStore(monitor);
    }

    public final void removeDescriptor(IArtifactKey key) {
        this.removeDescriptor(key, null);
    }

    public final void removeDescriptor(IArtifactKey key, IProgressMonitor monitor) {
        this.internalRemoveDescriptors(key);
        this.internalStore(monitor);
    }

    public final void removeDescriptors(IArtifactKey[] keys) {
        this.removeDescriptors(keys, null);
    }

    public final void removeDescriptors(IArtifactKey[] keys, IProgressMonitor monitor) {
        this.internalRemoveDescriptors(keys);
        this.internalStore(monitor);
    }

    public final void removeAll() {
        this.removeAll(null);
    }

    public final void removeAll(IProgressMonitor monitor) {
        this.internalRemoveAllDescriptors();
        this.internalStore(monitor);
    }

    public abstract IArtifactSink newAddingArtifactSink(IArtifactKey var1) throws ProvisionException;

    public abstract IRawArtifactSink newAddingRawArtifactSink(IArtifactDescriptor var1) throws ProvisionException;

    @Deprecated
    public final OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        try {
            IRawArtifactSink artifactSink = this.newAddingRawArtifactSink(descriptor);
            return new CommittingArtifactOutputStream(artifactSink);
        }
        catch (ArtifactSinkException e) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.tycho.p2.maven.repository", "Error while writing to artifact sink: " + e.getMessage(), (Throwable)e));
        }
    }

    @Deprecated
    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        try {
            IArtifactKey requestedKey = descriptor.getArtifactKey();
            IStatus status = this.getArtifact(ArtifactSinkFactory.writeToStream(requestedKey, destination), monitor);
            AbstractArtifactRepository2.setStatusOnStreamIfPossible(destination, status);
            return status;
        }
        catch (ArtifactSinkException e) {
            return new Status(4, "org.eclipse.tycho.p2.maven.repository", e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        try {
            IStatus status = this.getRawArtifact(ArtifactSinkFactory.rawWriteToStream(descriptor, destination), monitor);
            AbstractArtifactRepository2.setStatusOnStreamIfPossible(destination, status);
            return status;
        }
        catch (ArtifactSinkException e) {
            return new Status(4, "org.eclipse.tycho.p2.maven.repository", e.getMessage(), (Throwable)e);
        }
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)requests.length);
        try {
            MultiStatus result = new MultiStatus("org.eclipse.tycho.p2.maven.repository", 0, "Error while getting requested artifacts", null);
            IArtifactRequest[] iArtifactRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactRequest request = iArtifactRequestArray[n2];
                request.perform((IArtifactRepository)this, (IProgressMonitor)subMonitor.newChild(1));
                result.add(request.getResult());
                ++n2;
            }
            if (!result.isOK()) {
                MultiStatus multiStatus = result;
                return multiStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected static boolean isFatal(IStatus status) {
        return status.matches(12);
    }

    protected static void setStatusOnStreamIfPossible(OutputStream destination, IStatus status) {
        if (destination instanceof IStateful) {
            ((IStateful)destination).setStatus(status);
        }
    }

    private class CommittingArtifactOutputStream
    extends OutputStream
    implements IStateful {
        final IArtifactSink artifactSink;
        final OutputStream artifactOutputStream;
        private IStatus externallySetStatus = Status.OK_STATUS;

        public CommittingArtifactOutputStream(IArtifactSink artifactSink) throws ArtifactSinkException {
            this.artifactSink = artifactSink;
            this.artifactOutputStream = artifactSink.beginWrite();
        }

        public void setStatus(IStatus status) {
            if (status == null) {
                throw new NullPointerException();
            }
            this.externallySetStatus = status;
        }

        public IStatus getStatus() {
            return this.externallySetStatus;
        }

        @Override
        public void close() throws IOException {
            this.artifactOutputStream.close();
            try {
                if (AbstractArtifactRepository2.isFatal(this.externallySetStatus)) {
                    this.artifactSink.abortWrite();
                } else {
                    this.artifactSink.commitWrite();
                }
            }
            catch (ArtifactSinkException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.artifactOutputStream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.artifactOutputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.artifactOutputStream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.artifactOutputStream.flush();
        }
    }
}

