/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;

public class RequireActiveProfile
extends AbstractNonCacheableEnforcerRule {
    private String profiles = null;
    private boolean all = true;

    public final String getProfiles() {
        return this.profiles;
    }

    public final void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    public final boolean isAll() {
        return this.all;
    }

    public final void setAll(boolean all) {
        this.all = all;
    }

    public void execute(EnforcerRuleHelper theHelper) throws EnforcerRuleException {
        ArrayList<String> missingProfiles = new ArrayList<String>();
        try {
            MavenProject project = (MavenProject)theHelper.evaluate("${project}");
            if (StringUtils.isNotEmpty((String)this.profiles)) {
                String[] profileIds;
                for (String profileId : profileIds = this.profiles.split(",")) {
                    if (this.isProfileActive(project, profileId)) continue;
                    missingProfiles.add(profileId);
                }
                boolean fail = false;
                if (!missingProfiles.isEmpty() && (this.all || missingProfiles.size() == profileIds.length)) {
                    fail = true;
                }
                if (fail) {
                    String message = this.getMessage();
                    StringBuilder buf = new StringBuilder();
                    if (message != null) {
                        buf.append(message + System.lineSeparator());
                    }
                    for (String profile : missingProfiles) {
                        buf.append("Profile \"" + profile + "\" is not activated." + System.lineSeparator());
                    }
                    throw new EnforcerRuleException(buf.toString());
                }
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to retrieve the project.", (Exception)((Object)e));
        }
    }

    protected boolean isProfileActive(MavenProject project, String profileId) {
        for (Map.Entry entry : project.getInjectedProfileIds().entrySet()) {
            if (!((List)entry.getValue()).contains(profileId)) continue;
            return true;
        }
        return false;
    }
}

