/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ColumnInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.IItemResultSet;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ItemResultSetException;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.SingleEntryItemCollection;

final class DefaultIItemResultSet
implements IItemResultSet {
    private final IItemQuery query;
    private final List<IAttribute<?>> attributes = new ArrayList();
    private final List<IAggregator<?, ?>> aggregators = new ArrayList();
    private final Map<String, ColumnInfo> info;
    private final ArrayList<Object[]> data = new ArrayList();
    private int cursor = -1;

    DefaultIItemResultSet(IItemCollection items, IItemQuery query) {
        this.query = query;
        this.attributes.addAll(query.getAttributes());
        this.aggregators.addAll(query.getAggregators());
        this.info = new HashMap<String, ColumnInfo>(this.attributes.size() + this.aggregators.size());
        this.initializeMetadata();
        this.calculateData(items);
    }

    private void calculateData(IItemCollection input) {
        block9: {
            block8: {
                input = input.apply(this.query.getFilter());
                if (this.query.getGroupBy() != null) break block8;
                for (IItemIterable iterable : input) {
                    IType type = iterable.getType();
                    IMemberAccessor[] accessors = new IMemberAccessor[this.attributes.size()];
                    for (int i = 0; i < accessors.length; ++i) {
                        accessors[i] = this.attributes.get(i).getAccessor(type);
                    }
                    for (IItem item : iterable) {
                        Object[] row = this.newRow();
                        for (int column = 0; column < this.attributes.size(); ++column) {
                            row[column] = accessors[column].getMember((Object)item);
                        }
                        for (int j = 0; j < this.aggregators.size(); ++j) {
                            row[column + j] = new SingleEntryItemCollection(item, input.getUnfilteredTimeRanges()).getAggregate(this.aggregators.get(j));
                        }
                        this.data.add(row);
                    }
                }
                break block9;
            }
            IAggregator aggregator = Aggregators.distinct((IAttribute)this.query.getGroupBy());
            Set aggregate = (Set)input.getAggregate(aggregator);
            if (aggregate == null) break block9;
            for (Object o : aggregate) {
                IItemCollection rowCollection = input.apply(ItemFilters.equals((ICanonicalAccessorFactory)this.query.getGroupBy(), o));
                Object[] row = this.newRow();
                for (int column = 0; column < this.attributes.size(); ++column) {
                    row[column] = DefaultIItemResultSet.getFirstNonNull(rowCollection, this.attributes.get(column));
                }
                for (int j = 0; j < this.aggregators.size(); ++j) {
                    row[column + j] = rowCollection.getAggregate(this.aggregators.get(j));
                }
                this.data.add(row);
            }
        }
    }

    private static Object getFirstNonNull(IItemCollection items, IAttribute<?> attribute) {
        for (IItemIterable iterable : items) {
            IType type = iterable.getType();
            IMemberAccessor accessor = attribute.getAccessor(type);
            if (accessor == null) continue;
            for (IItem item : iterable) {
                Object o = accessor.getMember((Object)item);
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    private Object[] newRow() {
        return new Object[this.getNoOfColumns()];
    }

    private void initializeMetadata() {
        int columnId;
        int count = 0;
        for (final IAttribute<?> iAttribute : this.attributes) {
            columnId = count++;
            this.info.put(iAttribute.getIdentifier(), new ColumnInfo(){

                @Override
                public String getColumnId() {
                    return iAttribute.getIdentifier();
                }

                @Override
                public int getColumn() {
                    return columnId;
                }
            });
        }
        for (final IAggregator iAggregator : this.aggregators) {
            columnId = count++;
            this.info.put(iAggregator.getName(), new ColumnInfo(){

                @Override
                public String getColumnId() {
                    return iAggregator.getName();
                }

                @Override
                public int getColumn() {
                    return columnId;
                }
            });
        }
    }

    @Override
    public IItemQuery getQuery() {
        return this.query;
    }

    @Override
    public Object getValue(int column) throws ItemResultSetException {
        if (this.cursor == -1) {
            throw new ItemResultSetException("Cursor before first row.");
        }
        if (column < this.getNoOfColumns()) {
            if (this.cursor < this.data.size()) {
                return this.data.get(this.cursor)[column];
            }
            throw new ItemResultSetException("Cursor beyond last row.");
        }
        throw new ItemResultSetException("The specified column (" + column + ") is not available!");
    }

    private int getNoOfColumns() {
        return this.attributes.size() + this.aggregators.size();
    }

    @Override
    public Map<String, ColumnInfo> getColumnMetadata() {
        return this.info;
    }

    @Override
    public boolean next() {
        ++this.cursor;
        return this.cursor < this.data.size();
    }
}

