/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.latency;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public final class BiasedLockingRevocationPauseRule
implements IRule {
    public static final TypedPreference<IQuantity> INFO_LIMIT = new TypedPreference("vm.biasedrevocationpause.info.limit", Messages.getString("BiasedLockingRevocationPauseRule_CONFIG_WARNING_LIMIT"), Messages.getString("BiasedLockingRevocationPauseRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(100L));
    public static final TypedResult<IQuantity> REVOCATION_TIME = new TypedResult("revocationTime", "Revocation Time", "Time spent revoking biased locks.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    private static final String RESULT_ID = "biasedLockingRevocationPause";
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(INFO_LIMIT);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, REVOCATION_TIME);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ExecuteVMOperation", RulesToolkit.EventAvailability.ENABLED).build();

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IItemCollection revocationEvents = items.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.VM_OPERATIONS, ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.OPERATION, (String)"RevokeBias")}));
        if (!revocationEvents.hasItems()) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("BiasedLockingRevocationPauseRule_TEXT_OK")).build();
        }
        ITypedQuantity timeSpentRevoking = revocationEvents.hasItems() ? (IQuantity)revocationEvents.getAggregate(Aggregators.sum((IAttribute)JfrAttributes.DURATION)) : UnitLookup.MILLISECOND.quantity(0L);
        double score = RulesToolkit.mapExp100Y((double)timeSpentRevoking.doubleValueIn((IUnit)UnitLookup.MILLISECOND), (double)((IQuantity)valueProvider.getPreferenceValue(INFO_LIMIT)).doubleValueIn((IUnit)UnitLookup.MILLISECOND), (double)25.0);
        ResultBuilder builder = ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("BiasedLockingRevocationPauseRule_TEXT_MESSAGE")).addResult(REVOCATION_TIME, (Object)timeSpentRevoking).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score));
        if (score >= 25.0) {
            builder.setExplanation(Messages.getString("BiasedLockingRevocationPauseRule_TEXT_INFO_LONG"));
        }
        return builder.build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return BiasedLockingRevocationPauseRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("BiasedLockingRevocationPauseRule_RULE_NAME");
    }

    public String getTopic() {
        return "vm_operations";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

