/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.openjdk.jmc.flightrecorder.writer.CompositeTypeImpl;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TestType;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class TypedValueImplTest {
    private ConstantPools constantPools;
    private MetadataImpl metadata;
    private TypesImpl types;

    TypedValueImplTest() {
    }

    @BeforeEach
    void setup() {
        this.constantPools = new ConstantPools();
        this.metadata = new MetadataImpl(this.constantPools);
        this.types = new TypesImpl(this.metadata);
    }

    @Test
    void invalidValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.types.getType((Types.Predefined)Types.Builtin.STRING).asValue(1));
    }

    @Test
    void ofBuiltinNonCp() {
        TypeImpl type = this.types.getType((Types.Predefined)Types.Builtin.INT);
        TypedValueImpl value = type.asValue(1);
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)type, (Object)value.getType());
        Assertions.assertEquals((Object)1, (Object)value.getValue());
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)value.getConstantPoolIndex());
    }

    @Test
    void ofBuiltinCp() {
        TypeImpl type = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        String targetValue = "hello";
        TypedValueImpl value = type.asValue(targetValue);
        Assertions.assertNotNull((Object)value);
        Assertions.assertFalse((boolean)value.isNull());
        Assertions.assertEquals((Object)type, (Object)value.getType());
        Assertions.assertEquals((Object)targetValue, (Object)value.getValue());
        Assertions.assertNotEquals((long)Long.MIN_VALUE, (long)value.getConstantPoolIndex());
    }

    @Test
    void ofCustom() {
        String targetValue = "hello";
        TypeImpl type = this.types.getOrAdd("type.Custom", t -> t.addField("field", (Type)this.types.getType((Types.Predefined)Types.Builtin.STRING)));
        TypedValueImpl value = type.asValue(v -> v.putField("field", targetValue));
        Assertions.assertNotNull((Object)value);
        Assertions.assertFalse((boolean)value.isNull());
        Assertions.assertEquals((Object)type, (Object)value.getType());
        Assertions.assertEquals((Object)targetValue, (Object)value.getValue());
        Assertions.assertNotEquals((long)Long.MIN_VALUE, (long)value.getConstantPoolIndex());
    }

    @Test
    void ofCustomNoCP() {
        TypeStructureImpl structure = new TypeStructureImpl(Collections.singletonList(new TypedFieldImpl(this.types.getType((Types.Predefined)Types.Builtin.STRING), "field")), Collections.emptyList());
        CompositeTypeImpl nonCpType = new CompositeTypeImpl(1234L, "test.Type", null, structure, null, this.types);
        TypedValueImpl typedValue = nonCpType.asValue(t -> t.putField("field", "Ho!"));
        Assertions.assertNotNull((Object)typedValue);
    }

    @ParameterizedTest
    @EnumSource(value=Types.Builtin.class)
    void ofNull(Types.Builtin type) {
        TypedValueImpl nullValue = TypedValueImpl.ofNull((TypeImpl)this.types.getType((Types.Predefined)type));
        Assertions.assertNotNull((Object)nullValue);
        Assertions.assertTrue((boolean)nullValue.isNull());
        Assertions.assertThrows(NullPointerException.class, () -> ((TypedValueImpl)nullValue).getFieldValues());
    }

    @Test
    void ofNullInvalid() {
        TestType type1 = new TestType(1234L, "test.Type", null, this.constantPools, this.types){

            @Override
            public boolean canAccept(Object value) {
                return value != null;
            }
        };
        Assertions.assertThrows(IllegalArgumentException.class, () -> TypedValueImpl.ofNull((TypeImpl)type1));
    }

    @Test
    void ofNullCustom() {
        TypeImpl type = this.types.getOrAdd("type.Custom", t -> t.addField("field", (Type)this.types.getType((Types.Predefined)Types.Builtin.STRING)));
        Assertions.assertNotNull((Object)TypedValueImpl.ofNull((TypeImpl)type));
    }

    @Test
    void copyBuiltinWithCp() {
        int newCpIndex = 10;
        TypeImpl type = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        String targetValue = "hello";
        TypedValueImpl value = new TypedValueImpl(type, (Object)targetValue, -1L);
        Assertions.assertEquals((long)-1L, (long)value.getConstantPoolIndex());
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TypedValueImpl(value, (long)newCpIndex));
    }

    @Test
    void copyCustomWithCp() {
        int newCpIndex = 10;
        String targetValue = "hello";
        TypeImpl type = this.types.getOrAdd("type.Custom", t -> t.addField("field", (Type)this.types.getType((Types.Predefined)Types.Builtin.STRING)));
        TypedValueImpl value = new TypedValueImpl(type, Collections.singletonMap("field", new TypedFieldValueImpl(type.getField("field"), type.getField("field").getType().asValue(targetValue))), -1L);
        Assertions.assertEquals((long)-1L, (long)value.getConstantPoolIndex());
        Assertions.assertEquals((long)newCpIndex, (long)new TypedValueImpl(value, (long)newCpIndex).getConstantPoolIndex());
    }

    @Test
    void getFieldValues() {
        TypeImpl type = this.types.getOrAdd("type.Custom", t -> t.addField("field1", (Type)this.types.getType((Types.Predefined)Types.Builtin.STRING)).addField("field2", (Type)this.types.getType((Types.Predefined)Types.Builtin.STRING)));
        TypedValueImpl typedValue = type.asValue(v -> v.putField("field1", "value1"));
        List fields = typedValue.getFieldValues();
        Assertions.assertEquals((int)2, (int)fields.size());
        for (TypedFieldValueImpl tValue : fields) {
            Assertions.assertNotNull((Object)tValue);
            if (tValue.getValue().isNull()) {
                Assertions.assertNull((Object)tValue.getValue().getValue());
                continue;
            }
            Assertions.assertEquals((Object)"value1", (Object)tValue.getValue().getValue());
        }
    }

    @Test
    void testEquality() {
        TypeImpl type1 = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        TypeImpl type2 = this.types.getOrAdd("type.Custom", t -> t.addField("field1", (Type)this.types.getType((Types.Predefined)Types.Builtin.STRING)).addField("field2", (Type)this.types.getType((Types.Predefined)Types.Builtin.STRING)));
        TypedValueImpl value1_1 = type1.asValue("hello");
        TypedValueImpl value1_2 = type1.asValue("world");
        TypedValueImpl value2_1 = type2.asValue(v -> v.putField("field1", "hello"));
        TypedValueImpl value2_2 = type2.asValue(v -> v.putField("field2", "world"));
        Assertions.assertEquals((Object)value1_1, (Object)value1_1);
        Assertions.assertEquals((Object)value1_2, (Object)value1_2);
        Assertions.assertEquals((Object)value2_1, (Object)value2_1);
        Assertions.assertEquals((Object)value2_2, (Object)value2_2);
        Assertions.assertNotEquals(null, (Object)value1_1);
        Assertions.assertNotEquals(null, (Object)value1_2);
        Assertions.assertNotEquals(null, (Object)value2_1);
        Assertions.assertNotEquals(null, (Object)value2_2);
        Assertions.assertNotEquals((Object)value1_1, null);
        Assertions.assertNotEquals((Object)value1_2, null);
        Assertions.assertNotEquals((Object)value2_1, null);
        Assertions.assertNotEquals((Object)value2_2, null);
        Assertions.assertNotEquals((Object)1, (Object)value1_1);
        Assertions.assertNotEquals((Object)1, (Object)value1_2);
        Assertions.assertNotEquals((Object)1, (Object)value2_1);
        Assertions.assertNotEquals((Object)1, (Object)value2_2);
        Assertions.assertNotEquals((Object)value1_1, (Object)1);
        Assertions.assertNotEquals((Object)value1_2, (Object)1);
        Assertions.assertNotEquals((Object)value2_1, (Object)1);
        Assertions.assertNotEquals((Object)value2_2, (Object)1);
        Assertions.assertNotEquals((Object)value1_1, (Object)value1_2);
        Assertions.assertNotEquals((Object)value1_1, (Object)value2_1);
        Assertions.assertNotEquals((Object)value1_1, (Object)value2_2);
        Assertions.assertNotEquals((Object)value1_2, (Object)value1_1);
        Assertions.assertNotEquals((Object)value1_2, (Object)value2_1);
        Assertions.assertNotEquals((Object)value1_2, (Object)value2_2);
        Assertions.assertNotEquals((Object)value2_1, (Object)value1_1);
        Assertions.assertNotEquals((Object)value2_1, (Object)value1_2);
        Assertions.assertNotEquals((Object)value2_1, (Object)value2_2);
        Assertions.assertNotEquals((Object)value2_2, (Object)value1_1);
        Assertions.assertNotEquals((Object)value2_2, (Object)value1_2);
        Assertions.assertNotEquals((Object)value2_2, (Object)value2_1);
    }
}

