/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openjdk.jmc.flightrecorder.writer.BuiltinType;
import org.openjdk.jmc.flightrecorder.writer.CompositeTypeImpl;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class TypedFieldBuilderImplTest {
    private static final String FIELD_NAME = "field";
    private static final String CUSTOM_TYPE_NAME = "test.Type";
    private static final String ANNOTATION_TYPE_NAME = "jdk.jfr.Label";
    private static final String ANNOTATION_LABEL = "test.Label";
    private TypedFieldBuilderImpl instance;
    private TypeImpl stringType;
    private TypeImpl customType;
    private TypeImpl annotationType;

    TypedFieldBuilderImplTest() {
    }

    @BeforeEach
    void setUp() {
        TypesImpl types = (TypesImpl)Mockito.mock(TypesImpl.class);
        ConstantPools constantPools = new ConstantPools();
        this.stringType = new BuiltinType(1L, Types.Builtin.STRING, constantPools, types);
        List<TypedFieldImpl> customTypeFields = Collections.singletonList(new TypedFieldImpl(this.stringType, "item"));
        this.customType = new CompositeTypeImpl(2L, CUSTOM_TYPE_NAME, null, new TypeStructureImpl(customTypeFields, Collections.emptyList()), constantPools, types);
        this.annotationType = new CompositeTypeImpl(3L, ANNOTATION_TYPE_NAME, "java.lang.annotation.Annotation", new TypeStructureImpl(Collections.singletonList(new TypedFieldImpl(this.stringType, "value")), Collections.emptyList()), constantPools, types);
        Mockito.when((Object)types.getType((Types.Predefined)ArgumentMatchers.any(Types.Predefined.class))).thenAnswer(i -> ((Types.Predefined)i.getArgument(0)).getTypeName().equals(ANNOTATION_TYPE_NAME) ? this.annotationType : this.stringType);
        Mockito.when((Object)types.getType(ArgumentMatchers.matches((String)CUSTOM_TYPE_NAME.replace(".", "\\.")))).thenReturn((Object)this.customType);
        Mockito.when((Object)types.getType(ArgumentMatchers.matches((String)ANNOTATION_TYPE_NAME.replace(".", "\\.")))).thenReturn((Object)this.annotationType);
        this.instance = new TypedFieldBuilderImpl(FIELD_NAME, this.customType, types);
    }

    @Test
    void addAnnotationNullValue() {
        TypedFieldImpl field = this.instance.addAnnotation((Type)this.annotationType).build();
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)FIELD_NAME, (Object)field.getName());
        Assertions.assertEquals((Object)this.customType, (Object)field.getType());
        Assertions.assertEquals((int)1, (int)field.getAnnotations().size());
        Annotation annotation = (Annotation)field.getAnnotations().get(0);
        Assertions.assertEquals((Object)this.annotationType, (Object)annotation.getType());
        Assertions.assertNull((Object)annotation.getValue());
    }

    @Test
    void addPredefinedAnnotationNullValue() {
        TypedFieldImpl field = this.instance.addAnnotation((Types.Predefined)Types.JDK.ANNOTATION_LABEL).build();
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)FIELD_NAME, (Object)field.getName());
        Assertions.assertEquals((Object)this.customType, (Object)field.getType());
        Assertions.assertEquals((int)1, (int)field.getAnnotations().size());
        Annotation annotation = (Annotation)field.getAnnotations().get(0);
        Assertions.assertEquals((Object)this.annotationType, (Object)annotation.getType());
        Assertions.assertNull((Object)annotation.getValue());
    }

    @Test
    void addAnnotationValue() {
        TypedFieldImpl field = this.instance.addAnnotation((Type)this.annotationType, ANNOTATION_LABEL).build();
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)FIELD_NAME, (Object)field.getName());
        Assertions.assertEquals((Object)this.customType, (Object)field.getType());
        Assertions.assertEquals((int)1, (int)field.getAnnotations().size());
        Annotation annotation = (Annotation)field.getAnnotations().get(0);
        Assertions.assertEquals((Object)this.annotationType, (Object)annotation.getType());
        Assertions.assertEquals((Object)ANNOTATION_LABEL, (Object)annotation.getValue());
    }

    @Test
    void addPredefinedAnnotationValue() {
        TypedFieldImpl field = this.instance.addAnnotation((Types.Predefined)Types.JDK.ANNOTATION_LABEL, ANNOTATION_LABEL).build();
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)FIELD_NAME, (Object)field.getName());
        Assertions.assertEquals((Object)this.customType, (Object)field.getType());
        Assertions.assertEquals((int)1, (int)field.getAnnotations().size());
        Annotation annotation = (Annotation)field.getAnnotations().get(0);
        Assertions.assertEquals((Object)this.annotationType, (Object)annotation.getType());
        Assertions.assertEquals((Object)ANNOTATION_LABEL, (Object)annotation.getValue());
    }

    @Test
    void asArray() {
        TypedFieldImpl field = this.instance.asArray().build();
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)field.isArray());
    }
}

