/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.combine;

import java.util.ArrayList;
import java.util.Iterator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanLimit;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanSquare;

public class SpanToolkit {
    public static SpanSquare getMaxCountCluster(IItemCollection items, IAttribute<IQuantity> countAttribute, IAttribute<IQuantity> timestampAttribute) {
        IItemIterable ii;
        Iterator itemIt;
        Iterator iiIterator = items.iterator();
        if (iiIterator.hasNext() && (itemIt = (ii = (IItemIterable)iiIterator.next()).iterator()).hasNext()) {
            IType type = ii.getType();
            IMemberAccessor countAccessor = countAttribute.getAccessor(type);
            IMemberAccessor timeAccessor = timestampAttribute.getAccessor(type);
            ArrayList<SpanSquare> spans = new ArrayList<SpanSquare>();
            IItem first = (IItem)itemIt.next();
            long lastCount = ((IQuantity)countAccessor.getMember((Object)first)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
            long lastTimestamp = ((IQuantity)timeAccessor.getMember((Object)first)).clampedLongValueIn((IUnit)UnitLookup.EPOCH_NS);
            while (itemIt.hasNext()) {
                IItem item = (IItem)itemIt.next();
                long count = ((IQuantity)countAccessor.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
                long time = ((IQuantity)timeAccessor.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.EPOCH_NS);
                spans.add(new SpanSquare(lastTimestamp, time, count - lastCount));
                lastCount = count;
                lastTimestamp = time;
            }
            return SpanSquare.getMax(spans.toArray(new SpanSquare[spans.size()]));
        }
        return null;
    }

    public static SpanSquare getMaxDurationCluster(IItemCollection items) {
        Iterator iiIterator = items.iterator();
        if (iiIterator.hasNext()) {
            IItemIterable ii = (IItemIterable)iiIterator.next();
            Iterator itemIt = ii.iterator();
            IType type = ii.getType();
            IMemberAccessor startTime = JfrAttributes.START_TIME.getAccessor(type);
            IMemberAccessor endTime = JfrAttributes.END_TIME.getAccessor(type);
            ArrayList<SpanSquare> span = new ArrayList<SpanSquare>();
            while (itemIt.hasNext()) {
                IItem item = (IItem)itemIt.next();
                long st = ((IQuantity)startTime.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.EPOCH_NS);
                long et = ((IQuantity)endTime.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.EPOCH_NS);
                span.add(new SpanSquare(st, et));
            }
            return SpanSquare.getMax(span.toArray(new SpanSquare[span.size()]));
        }
        return null;
    }

    public static SpanLimit getMaxSpanLimit(IItemCollection items, IAttribute<IQuantity> valueAttribute, IAttribute<IQuantity> endTimeAttribute, double limit) {
        SpanLimit max = null;
        ArrayList<SpanLimit> periods = new ArrayList<SpanLimit>();
        boolean first = true;
        double lastCount = 0.0;
        long lastTimestamp = 0L;
        Iterator itemsIterator = items.iterator();
        if (itemsIterator.hasNext()) {
            IItemIterable itemIterable = (IItemIterable)itemsIterator.next();
            Iterator itemIterator = itemIterable.iterator();
            IMemberAccessor valueAccessor = valueAttribute.getAccessor(itemIterable.getType());
            IMemberAccessor endTimeAccessor = endTimeAttribute.getAccessor(itemIterable.getType());
            while (itemIterator.hasNext()) {
                IItem item = (IItem)itemIterator.next();
                IQuantity value = (IQuantity)valueAccessor.getMember((Object)item);
                if (value == null) continue;
                double count = value.doubleValue();
                long time = ((IQuantity)endTimeAccessor.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.EPOCH_NS);
                if (first) {
                    lastCount = count;
                    lastTimestamp = time;
                    first = false;
                    continue;
                }
                periods.add(new SpanLimit(lastTimestamp, time, (count + lastCount) / 2.0, limit));
                lastCount = count;
                lastTimestamp = time;
            }
            if (periods.size() > 0) {
                max = SpanLimit.getMaxSpan(periods.toArray(new SpanLimit[0]));
            }
        }
        return max;
    }
}

