/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.XMLInputStreamReader;
import de.pdark.decentxml.XMLStringSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

public class XMLIOSource
extends XMLStringSource {
    public XMLIOSource(InputStream in) throws IOException {
        this(new XMLInputStreamReader(in));
    }

    public XMLIOSource(Reader reader) throws IOException {
        super(XMLIOSource.toString(reader));
    }

    public XMLIOSource(File file) throws IOException {
        super(XMLIOSource.toString(file));
    }

    public XMLIOSource(URL url) throws IOException {
        super(XMLIOSource.toString(url));
    }

    public static String toString(URL url) throws IOException {
        return XMLIOSource.toString(url.openStream());
    }

    public static String toString(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        return XMLIOSource.toString(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream in) throws IOException {
        Reader reader = null;
        IOException exception = null;
        String result = null;
        try {
            reader = new XMLInputStreamReader(new BufferedInputStream(in));
            result = XMLIOSource.toString(reader);
        }
        catch (IOException e) {
            exception = e;
        }
        finally {
            block14: {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    if (exception != null) break block14;
                    exception = e;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    public static String toString(Reader reader) throws IOException {
        int len;
        StringBuilder buffer = new StringBuilder(10240);
        char[] cbuf = new char[10240];
        while ((len = reader.read(cbuf)) != -1) {
            buffer.append(cbuf, 0, len);
        }
        return buffer.toString();
    }
}

