/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.baseline;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.core.resolver.shared.MavenRepositoryLocation;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.impl.publisher.P2Artifact;
import org.eclipse.tycho.p2.metadata.IP2Artifact;
import org.eclipse.tycho.p2.remote.IRepositoryIdManager;
import org.eclipse.tycho.p2.remote.RemoteAgentManager;
import org.eclipse.tycho.p2.tools.baseline.facade.BaselineService;
import org.eclipse.tycho.repository.util.StatusTool;

public class BaselineServiceImpl
implements BaselineService {
    private IProgressMonitor monitor = new NullProgressMonitor();
    private RemoteAgentManager remoteAgentManager;
    private MavenContext mavenContext;

    public Map<String, IP2Artifact> getProjectBaseline(Collection<MavenRepositoryLocation> baselineLocations, Map<String, IP2Artifact> reactor, File target) {
        CompositeArtifactRepository baselineArtifacts;
        CompositeMetadataRepository baselineUnits;
        try {
            IProvisioningAgent remoteAgent = this.remoteAgentManager.getProvisioningAgent();
            IRepositoryIdManager remoteRepositoryIdManager = (IRepositoryIdManager)remoteAgent.getService(IRepositoryIdManager.SERVICE_NAME);
            IMetadataRepositoryManager remoteMetadataRepositoryManager = (IMetadataRepositoryManager)remoteAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IArtifactRepositoryManager remoteArtifactRepositoryManager = (IArtifactRepositoryManager)remoteAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            baselineUnits = CompositeMetadataRepository.createMemoryComposite((IProvisioningAgent)remoteAgent);
            baselineArtifacts = CompositeArtifactRepository.createMemoryComposite((IProvisioningAgent)remoteAgent);
            for (MavenRepositoryLocation location : baselineLocations) {
                URI url = location.getURL();
                try {
                    remoteRepositoryIdManager.addMapping(location.getId(), url);
                    remoteMetadataRepositoryManager.loadRepository(url, this.monitor);
                    remoteArtifactRepositoryManager.loadRepository(url, this.monitor);
                    baselineUnits.addChild(url);
                    baselineArtifacts.addChild(url);
                }
                catch (ProvisionException e) {
                    this.mavenContext.getLogger().warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (ProvisionException e) {
            throw new RuntimeException(e);
        }
        LinkedHashMap<String, IP2Artifact> result = new LinkedHashMap<String, IP2Artifact>();
        for (Map.Entry<String, IP2Artifact> reactorArtifact : reactor.entrySet()) {
            IArtifactDescriptor descriptor = (IArtifactDescriptor)reactorArtifact.getValue().getArtifactDescriptor();
            IArtifactDescriptor baselineDescriptor = this.getBaselineDescriptor((IArtifactRepository)baselineArtifacts, descriptor);
            if (baselineDescriptor == null) continue;
            IArtifactKey baslineKey = baselineDescriptor.getArtifactKey();
            String format = baselineDescriptor.getProperty("format");
            File baselineArtifact = new File(target, String.valueOf(baslineKey.getClassifier()) + "/" + baslineKey.getId() + "/" + baslineKey.getVersion() + (format != null ? "." + format : ""));
            try {
                baselineArtifact.getParentFile().mkdirs();
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(baselineArtifact));
                try {
                    IStatus status = baselineArtifacts.getRawArtifact(baselineDescriptor, (OutputStream)os, this.monitor);
                    if (status.matches(12)) {
                        String repository = baselineDescriptor.getRepository().getLocation().toString();
                        String artifactId = baselineDescriptor.getArtifactKey().getId();
                        String artifactVersion = baselineDescriptor.getArtifactKey().getVersion().toString();
                        String statusMessage = StatusTool.toLogMessage((IStatus)status);
                        throw new RuntimeException(String.format("Error trying to download %s version %s from %s:\n%s", artifactId, artifactVersion, repository, statusMessage), StatusTool.findException((IStatus)status));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ArrayList<IInstallableUnit> units = new ArrayList<IInstallableUnit>();
            for (Object _unit : reactorArtifact.getValue().getInstallableUnits()) {
                IInstallableUnit unit = (IInstallableUnit)_unit;
                IInstallableUnit baselineUnit = this.getBaselineUnit((IQueryable<IInstallableUnit>)baselineUnits, unit.getId(), unit.getVersion());
                if (baselineUnit == null) continue;
                units.add(baselineUnit);
            }
            result.put(reactorArtifact.getKey(), (IP2Artifact)new P2Artifact(baselineArtifact, units, descriptor));
        }
        return !result.isEmpty() ? result : null;
    }

    private IArtifactDescriptor getBaselineDescriptor(IArtifactRepository baseline, IArtifactDescriptor descriptor) {
        IArtifactDescriptor[] baselineDescriptors;
        IArtifactDescriptor[] iArtifactDescriptorArray = baselineDescriptors = baseline.getArtifactDescriptors(descriptor.getArtifactKey());
        int n = baselineDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor baselineDescriptor = iArtifactDescriptorArray[n2];
            if (BaselineServiceImpl.eq(descriptor.getProperty("format"), baselineDescriptor.getProperty("format")) && Arrays.equals(descriptor.getProcessingSteps(), baselineDescriptor.getProcessingSteps())) {
                return baselineDescriptor;
            }
            ++n2;
        }
        return null;
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    private IInstallableUnit getBaselineUnit(IQueryable<IInstallableUnit> units, String id, Version version) {
        IQueryResult result = units.query(QueryUtil.createIUQuery((String)id, (Version)version), this.monitor);
        if (result.isEmpty()) {
            return null;
        }
        Iterator iterator = result.iterator();
        IInstallableUnit unit = (IInstallableUnit)iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        return unit;
    }

    public boolean isMetadataEqual(IP2Artifact baseline, IP2Artifact reactor) {
        return true;
    }

    public void setRemoteAgentManager(RemoteAgentManager remoteAgentManager) {
        this.remoteAgentManager = remoteAgentManager;
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }
}

