/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.p2.resolver.ClassifiedArtifactKey;
import org.eclipse.tycho.p2.resolver.ClassifiedLocation;
import org.eclipse.tycho.p2.resolver.DefaultP2ResolutionResultEntry;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;
import org.eclipse.tycho.p2.target.P2TargetPlatform;

public class DefaultP2ResolutionResult
implements P2ResolutionResult {
    private final Map<ClassifiedArtifactKey, P2ResolutionResult.Entry> entries = new LinkedHashMap<ClassifiedArtifactKey, P2ResolutionResult.Entry>();
    private final Map<ClassifiedLocation, P2ResolutionResult.Entry> entriesByLocation = new LinkedHashMap<ClassifiedLocation, P2ResolutionResult.Entry>();
    private final Set<Object> nonReactorUnits = new LinkedHashSet<Object>();

    public Collection<P2ResolutionResult.Entry> getArtifacts() {
        return this.entries.values();
    }

    public void addArtifact(ArtifactKey artifactKey, String classifier, IInstallableUnit installableUnit, IArtifactKey p2ArtifactKey, P2TargetPlatform resolutionContext) {
        if (resolutionContext.isFileAlreadyAvailable(artifactKey)) {
            this.addResolvedArtifact(Optional.of(artifactKey), classifier, installableUnit, resolutionContext.getArtifactLocation(artifactKey));
            return;
        }
        ClassifiedArtifactKey key = new ClassifiedArtifactKey(artifactKey, classifier);
        DefaultP2ResolutionResultEntry entry = (DefaultP2ResolutionResultEntry)this.entries.get(key);
        if (entry == null) {
            entry = new DefaultP2ResolutionResultEntry(artifactKey.getType(), artifactKey.getId(), artifactKey.getVersion(), classifier, () -> {
                File res = resolutionContext.getLocalArtifactFile(p2ArtifactKey);
                resolutionContext.saveLocalMavenRepository();
                return res;
            });
            this.entries.put(key, entry);
            File location = entry.getLocation(false);
            if (location != null) {
                this.entriesByLocation.put(new ClassifiedLocation(location, classifier), entry);
            }
        }
        entry.addInstallableUnit(installableUnit);
    }

    public void addResolvedArtifact(Optional<ArtifactKey> artifactKey, String classifier, IInstallableUnit installableUnit, File location) {
        ClassifiedLocation classifiedLocation = new ClassifiedLocation(location, classifier);
        DefaultP2ResolutionResultEntry existingEntryForLocation = (DefaultP2ResolutionResultEntry)this.entriesByLocation.get(classifiedLocation);
        Optional<ClassifiedArtifactKey> classifiedArtifactKey = artifactKey.map(a -> new ClassifiedArtifactKey((ArtifactKey)a, classifier));
        if (existingEntryForLocation == null) {
            DefaultP2ResolutionResultEntry newEntry = new DefaultP2ResolutionResultEntry((String)artifactKey.map(ArtifactKey::getType).orElse(null), (String)artifactKey.map(ArtifactKey::getId).orElse(null), (String)artifactKey.map(ArtifactKey::getVersion).orElse(null), classifier, location);
            newEntry.addInstallableUnit(installableUnit);
            this.entriesByLocation.put(new ClassifiedLocation(location, classifier), newEntry);
            classifiedArtifactKey.ifPresent(key -> {
                P2ResolutionResult.Entry entry = this.entries.put((ClassifiedArtifactKey)key, newEntry);
            });
        } else {
            existingEntryForLocation.addInstallableUnit(installableUnit);
            artifactKey.ifPresent(key -> {
                if (key.getType() == null) {
                    return;
                }
                if (!("eclipse-product".equals(existingEntryForLocation.getType()) && "eclipse-product".equals(key.getType()) || existingEntryForLocation.getType() == null || classifier != null || key.getType().equals(existingEntryForLocation.getType()) && key.getId().equals(existingEntryForLocation.getId()) && key.getVersion().equals(existingEntryForLocation.getVersion()))) {
                    throw new RuntimeException("Ambiguous main artifact of the project for " + ((ArtifactKey)artifactKey.get()).getId() + ". Make sure that additional units added via p2.inf specify a 'maven-classifier' property.");
                }
                existingEntryForLocation.setType(key.getType());
                existingEntryForLocation.setId(key.getId());
                existingEntryForLocation.setVersion(key.getVersion());
                classifiedArtifactKey.ifPresent(classifiedKey -> {
                    if (!this.entries.containsKey(classifiedKey)) {
                        this.entries.put((ClassifiedArtifactKey)classifiedKey, existingEntryForLocation);
                    }
                });
            });
        }
    }

    public void removeEntriesWithUnknownType() {
        this.entries.values().removeIf(entry -> entry.getType() == null);
    }

    public void addNonReactorUnit(IInstallableUnit installableUnit) {
        this.nonReactorUnits.add(installableUnit);
    }

    public void addNonReactorUnits(Set<IInstallableUnit> installableUnits) {
        this.nonReactorUnits.addAll(installableUnits);
    }

    public Set<?> getNonReactorUnits() {
        return this.nonReactorUnits;
    }
}

