/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.repository.p2base.artifact.provider.CompositeArtifactProviderBaseImpl;
import org.eclipse.tycho.repository.p2base.artifact.provider.IArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.ArtifactSinkException;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IArtifactSink;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IRawArtifactSink;

public class CompositeArtifactProvider
extends CompositeArtifactProviderBaseImpl
implements IRawArtifactFileProvider {
    private List<IRawArtifactFileProvider> components;

    public CompositeArtifactProvider(IRawArtifactFileProvider ... components) {
        this.components = Arrays.asList(components);
    }

    public CompositeArtifactProvider(List<IRawArtifactFileProvider> providers) {
        this.components = new ArrayList<IRawArtifactFileProvider>(providers);
    }

    public CompositeArtifactProvider(List<IRawArtifactFileProvider> providers1, List<IRawArtifactFileProvider> providers2) {
        this.components = new ArrayList<IRawArtifactFileProvider>(providers1.size() + providers2.size());
        this.components.addAll(providers1);
        this.components.addAll(providers2);
    }

    @Override
    public boolean contains(IArtifactKey key) {
        for (IRawArtifactFileProvider component : this.components) {
            if (!component.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(IArtifactDescriptor descriptor) {
        for (IRawArtifactFileProvider component : this.components) {
            if (!component.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void getArtifactDescriptorsOfAllSources(IArtifactKey key, Set<IArtifactDescriptor> result) {
        for (IRawArtifactFileProvider component : this.components) {
            IArtifactDescriptor[] iArtifactDescriptorArray = component.getArtifactDescriptors(key);
            int n = iArtifactDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
                result.add(descriptor);
                ++n2;
            }
        }
    }

    @Override
    public File getArtifactFile(IArtifactKey key) {
        for (IRawArtifactFileProvider component : this.components) {
            if (!component.contains(key)) continue;
            return component.getArtifactFile(key);
        }
        return null;
    }

    @Override
    public File getArtifactFile(IArtifactDescriptor descriptor) {
        for (IRawArtifactFileProvider component : this.components) {
            if (!component.contains(descriptor)) continue;
            return component.getArtifactFile(descriptor);
        }
        return null;
    }

    @Override
    protected void getArtifactFromAnySource(IArtifactSink sink, List<IStatus> statusCollector, IProgressMonitor monitor) throws ArtifactSinkException {
        IArtifactKey requestedKey = sink.getArtifactToBeWritten();
        for (IRawArtifactFileProvider component : this.components) {
            if (!component.contains(requestedKey)) continue;
            if (!sink.canBeginWrite()) {
                return;
            }
            IStatus transferStatus = component.getArtifact(sink, monitor);
            statusCollector.add(transferStatus);
            if (CompositeArtifactProvider.isFatal(transferStatus)) continue;
            return;
        }
    }

    @Override
    protected void getRawArtifactFromAnySource(IRawArtifactSink sink, IProgressMonitor monitor, List<IStatus> statusCollector) throws ArtifactSinkException {
        IArtifactDescriptor requestedDescriptor = sink.getArtifactFormatToBeWritten();
        for (IRawArtifactFileProvider component : this.components) {
            if (!component.contains(requestedDescriptor)) continue;
            if (!sink.canBeginWrite()) {
                return;
            }
            IStatus transferStatus = component.getRawArtifact(sink, monitor);
            statusCollector.add(transferStatus);
            if (CompositeArtifactProvider.isFatal(transferStatus)) continue;
            return;
        }
    }

    protected Status getArtifactNotFoundError(String artifact) {
        return new Status(4, "org.eclipse.tycho.p2.maven.repository", 1200, "Artifact " + artifact + " is not available in the following sources: " + this.components, null);
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        return this.componentsAsQueriable().query(query, monitor);
    }

    private IQueryable<IArtifactKey> componentsAsQueriable() {
        int repositoryCount = this.components.size();
        if (repositoryCount == 1) {
            return this.components.get(0);
        }
        IQueryable[] repositoriesArray = this.components.toArray(new IArtifactProvider[repositoryCount]);
        return new CompoundQueryable(repositoriesArray);
    }

    @Override
    public boolean isFileAlreadyAvailable(IArtifactKey artifactKey) {
        return this.components.stream().anyMatch(component -> component.isFileAlreadyAvailable(artifactKey));
    }
}

