/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.rules.report.html.JfrHtmlRulesReport;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;

public class RulesToolkitTest {
    private static final String JAVA_7_14_EA = "Java HotSpot(TM) Client VM (24.0-b36) for windows-x86 JRE (1.7.0_14-ea-b17), built on Mar 20 2013 10:28:38 by \"java_re\" with unknown MS VC++:1600";
    private static final String JAVA_8_40 = "Java HotSpot(TM) 64-Bit Server VM (25.60-b23) for windows-amd64 JRE (1.8.0_60-b31), built on Aug 12 2015 14:45:33 by \"java_re\" with MS VC++ 10.0 (VS2010)";

    @Test
    public void testMapLin100Straight() {
        Assert.assertEquals((double)0.0, (double)RulesToolkit.mapLin100((double)0.0, (double)0.25, (double)0.75), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RulesToolkit.mapLin100((double)1.0, (double)0.25, (double)0.75), (double)0.0);
        Assert.assertEquals((double)12.0, (double)RulesToolkit.mapLin100((double)0.12, (double)0.25, (double)0.75), (double)0.0);
        Assert.assertEquals((double)25.0, (double)RulesToolkit.mapLin100((double)0.25, (double)0.25, (double)0.75), (double)0.0);
        Assert.assertEquals((double)50.0, (double)RulesToolkit.mapLin100((double)0.5, (double)0.25, (double)0.75), (double)0.0);
        Assert.assertEquals((double)75.0, (double)RulesToolkit.mapLin100((double)0.75, (double)0.25, (double)0.75), (double)0.0);
        Assert.assertEquals((double)73.0, (double)RulesToolkit.mapLin100((double)0.73, (double)0.25, (double)0.75), (double)0.0);
    }

    @Test
    public void testMapLin100Multi() {
        Assert.assertEquals((double)0.0, (double)RulesToolkit.mapLin100((double)0.0, (double)0.1, (double)0.9), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RulesToolkit.mapLin100((double)1.0, (double)0.1, (double)0.9), (double)0.0);
        Assert.assertEquals((double)25.0, (double)RulesToolkit.mapLin100((double)0.1, (double)0.1, (double)0.9), (double)0.0);
        Assert.assertEquals((double)26.25, (double)RulesToolkit.mapLin100((double)0.12, (double)0.1, (double)0.9), (double)0.0);
        Assert.assertEquals((double)34.375, (double)RulesToolkit.mapLin100((double)0.25, (double)0.1, (double)0.9), (double)0.0);
        Assert.assertEquals((double)50.0, (double)RulesToolkit.mapLin100((double)0.5, (double)0.1, (double)0.9), (double)0.0);
        Assert.assertEquals((double)65.625, (double)RulesToolkit.mapLin100((double)0.75, (double)0.1, (double)0.9), (double)0.0);
        Assert.assertEquals((double)75.0, (double)RulesToolkit.mapLin100((double)0.9, (double)0.1, (double)0.9), (double)0.0);
    }

    @Test
    public void testGetJavaVersionEA() {
        JavaVersion javaVersion = RulesToolkit.getJavaVersion((String)JAVA_7_14_EA);
        Assert.assertTrue((boolean)javaVersion.isEarlyAccess());
    }

    @Test
    public void testGetJavaVersion() {
        JavaVersion javaVersion = RulesToolkit.getJavaVersion((String)JAVA_8_40);
        Assert.assertFalse((boolean)javaVersion.isEarlyAccess());
    }

    @Test
    public void testJfrHtmlRulesReportGeneration() {
        String report = "";
        try {
            report = JfrHtmlRulesReport.createReport((IItemCollection)RecordingToolkit.getNamedRecording((String)"8u60.jfr"));
        }
        catch (IOException | CouldNotLoadRecordingException e) {
            Assert.fail();
        }
        assert (!report.isEmpty());
    }
}

