/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.sonatype.guice.bean.locators.DefaultRankingFunction;
import org.sonatype.guice.bean.locators.InjectorPublisher;
import org.sonatype.guice.bean.locators.LocatedBeans;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.locators.RankedBindings;
import org.sonatype.guice.bean.locators.RankedList;
import org.sonatype.guice.bean.locators.RankingFunction;
import org.sonatype.guice.bean.locators.WatchedBeans;
import org.sonatype.guice.bean.locators.spi.BindingDistributor;
import org.sonatype.guice.bean.locators.spi.BindingPublisher;
import org.sonatype.inject.BeanEntry;
import org.sonatype.inject.Mediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class DefaultBeanLocator
implements MutableBeanLocator {
    private final RankedList<BindingPublisher> publishers = new RankedList();
    private final Map<TypeLiteral, RankedBindings> bindingsCache = new HashMap<TypeLiteral, RankedBindings>();
    private final List<WatchedBeans> watchedBeans = new ArrayList<WatchedBeans>();

    public synchronized Iterable<BeanEntry> locate(Key key) {
        return new LocatedBeans(key, this.bindingsForType(key.getTypeLiteral()));
    }

    public synchronized void watch(Key key, Mediator mediator, Object watcher) {
        WatchedBeans beans = new WatchedBeans(key, mediator, watcher);
        int size = this.publishers.size();
        for (int i = 0; i < size; ++i) {
            beans.add(this.publishers.get(i), 0);
        }
        this.watchedBeans.add(beans);
    }

    @Override
    public void add(Injector injector, int rank) {
        this.add(new InjectorPublisher(injector, new DefaultRankingFunction(rank)), rank);
    }

    @Override
    public void remove(Injector injector) {
        this.remove(new InjectorPublisher(injector, null));
    }

    @Override
    public synchronized void add(BindingPublisher publisher, int rank) {
        if (!this.publishers.contains(publisher)) {
            this.publishers.insert(publisher, rank);
            this.distribute(BindingEvent.ADD, publisher, rank);
        }
    }

    @Override
    public synchronized void remove(BindingPublisher publisher) {
        if (this.publishers.remove(publisher)) {
            this.distribute(BindingEvent.REMOVE, publisher, 0);
        }
    }

    @Override
    public synchronized void clear() {
        this.publishers.clear();
        this.distribute(BindingEvent.CLEAR, null, 0);
    }

    @Inject
    void autoPublish(Injector injector) {
        RankingFunction function = (RankingFunction)injector.getInstance(RankingFunction.class);
        this.add(new InjectorPublisher(injector, function), function.maxRank());
    }

    private <T> RankedBindings<T> bindingsForType(TypeLiteral<T> type) {
        RankedBindings<T> bindings = this.bindingsCache.get(type);
        if (null == bindings) {
            bindings = new RankedBindings<T>(type, this.publishers);
            this.bindingsCache.put(type, bindings);
        }
        return bindings;
    }

    private void distribute(BindingEvent event, BindingPublisher publisher, int rank) {
        Iterator<RankedBindings> itr = this.bindingsCache.values().iterator();
        while (itr.hasNext()) {
            RankedBindings bindings = itr.next();
            if (bindings.isActive()) {
                DefaultBeanLocator.notify(bindings, event, publisher, rank);
                continue;
            }
            itr.remove();
        }
        for (int i = 0; i < this.watchedBeans.size(); ++i) {
            WatchedBeans beans = this.watchedBeans.get(i);
            if (beans.isActive()) {
                DefaultBeanLocator.notify(beans, event, publisher, rank);
                continue;
            }
            this.watchedBeans.remove(i--);
        }
    }

    private static void notify(BindingDistributor distributor, BindingEvent event, BindingPublisher publisher, int rank) {
        switch (event) {
            case ADD: {
                distributor.add(publisher, rank);
                break;
            }
            case REMOVE: {
                distributor.remove(publisher);
                break;
            }
            case CLEAR: {
                distributor.clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BindingEvent {
        ADD,
        REMOVE,
        CLEAR;

    }
}

