/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;
import org.openjdk.jmc.flightrecorder.test.util.StacktraceTestToolkit;

public class StacktraceBaselineGenerator {
    public static void main(String[] args) throws URISyntaxException, IOException, CouldNotLoadRecordingException {
        File stacktracesDirectory = StacktraceTestToolkit.getStacktracesDirectory();
        File recordingDirectory = RecordingToolkit.getRecordingDirectory();
        System.out.println("Deleting all files in directory " + stacktracesDirectory);
        for (File file : stacktracesDirectory.listFiles()) {
            if (file.delete()) continue;
            System.out.println("Could not remove old files!\nExiting!");
            System.exit(1);
        }
        for (File recordingFile : recordingDirectory.listFiles()) {
            File stacktraceFile = new File(stacktracesDirectory, recordingFile.getName() + ".txt");
            System.out.println("Generating " + stacktraceFile + " ...");
            StacktraceTestToolkit.printStacktraces(recordingFile, stacktraceFile);
            System.out.println(" finished!");
        }
    }
}

