/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util.internal;

import java.lang.management.ManagementFactory;
import java.util.Map;

public final class ObjectUtils {
    private ObjectUtils() {
        throw new IllegalStateException("no instantiable constructor");
    }

    public static <T> T useNonNull(T target, T fallback) {
        return ObjectUtils.isNull(target) ? fallback : target;
    }

    public static boolean isNull(Object target) {
        return target == null;
    }

    public static boolean nonNull(Object target) {
        return !ObjectUtils.isNull(target);
    }

    public static <T> T requireNonNull(T obj, String message) {
        if (ObjectUtils.isNull(obj)) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj) {
        return ObjectUtils.requireNonNull(obj, null);
    }

    public static Map<String, String> systemProps() {
        return ManagementFactory.getRuntimeMXBean().getSystemProperties();
    }
}

