/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openjdk.jmc.flightrecorder.writer.BuiltinType;
import org.openjdk.jmc.flightrecorder.writer.CompositeTypeImpl;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypeStructure;
import org.openjdk.jmc.flightrecorder.writer.api.TypedField;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class TypeStructureBuilderImplTest {
    private static final String FIELD_NAME = "field";
    private static final String CUSTOM_TYPE_NAME = "test.Type";
    private static final String ANNOTATION_TYPE_NAME = "jdk.jfr.Label";
    private static final String ANNOTATION_LABEL = "test.Label";
    private TypeStructureBuilderImpl instance;
    private TypeImpl stringType;
    private TypeImpl customType;
    private TypeImpl annotationType;

    TypeStructureBuilderImplTest() {
    }

    @BeforeEach
    void setUp() {
        ConstantPools constantPools = new ConstantPools();
        TypesImpl types = (TypesImpl)Mockito.mock(TypesImpl.class);
        this.stringType = new BuiltinType(1L, Types.Builtin.STRING, constantPools, types);
        List<TypedFieldImpl> customTypeFields = Collections.singletonList(new TypedFieldImpl(this.stringType, "item"));
        this.customType = new CompositeTypeImpl(2L, CUSTOM_TYPE_NAME, null, new TypeStructureImpl(customTypeFields, Collections.emptyList()), constantPools, types);
        this.annotationType = new CompositeTypeImpl(3L, ANNOTATION_TYPE_NAME, "java.lang.annotation.Annotation", new TypeStructureImpl(Collections.singletonList(new TypedFieldImpl(this.stringType, "value")), Collections.emptyList()), constantPools, types);
        Mockito.when((Object)types.getType((Types.Predefined)ArgumentMatchers.any(Types.Predefined.class))).thenReturn((Object)this.stringType);
        Mockito.when((Object)types.getType(ArgumentMatchers.matches((String)CUSTOM_TYPE_NAME.replace(".", "\\.")))).thenReturn((Object)this.customType);
        Mockito.when((Object)types.getType(ArgumentMatchers.matches((String)ANNOTATION_TYPE_NAME.replace(".", "\\.")))).thenReturn((Object)this.annotationType);
        this.instance = new TypeStructureBuilderImpl(types);
    }

    @Test
    void addFieldPredefined() {
        TypeStructure structure = this.instance.addField(FIELD_NAME, (Types.Predefined)Types.Builtin.STRING).build();
        Assertions.assertEquals((int)1, (int)structure.getFields().size());
        Assertions.assertEquals((int)0, (int)structure.getAnnotations().size());
        TypedField field = (TypedField)structure.getFields().get(0);
        Assertions.assertEquals((Object)FIELD_NAME, (Object)field.getName());
        Assertions.assertEquals((Object)this.stringType, (Object)field.getType());
    }

    @Test
    void testAddFieldCustom() {
        TypeStructure structure = this.instance.addField(FIELD_NAME, (Type)this.customType).build();
        Assertions.assertEquals((int)1, (int)structure.getFields().size());
        TypedField field = (TypedField)structure.getFields().get(0);
        Assertions.assertEquals((Object)FIELD_NAME, (Object)field.getName());
        Assertions.assertEquals((Object)this.customType, (Object)field.getType());
    }

    @Test
    void addFieldNullName() {
        Assertions.assertThrows(NullPointerException.class, () -> this.instance.addField(null, (Types.Predefined)Types.Builtin.STRING));
    }

    @Test
    void addFieldNullType() {
        Assertions.assertThrows(NullPointerException.class, () -> this.instance.addField(FIELD_NAME, (Types.Predefined)null));
        Assertions.assertThrows(NullPointerException.class, () -> this.instance.addField(FIELD_NAME, (Type)((TypeImpl)null)));
    }

    @Test
    void addAnnotation() {
        TypeStructure structure = this.instance.addAnnotation((Type)this.annotationType, ANNOTATION_LABEL).build();
        Assertions.assertEquals((int)0, (int)structure.getFields().size());
        Assertions.assertEquals((int)1, (int)structure.getAnnotations().size());
        Annotation annotation = (Annotation)structure.getAnnotations().get(0);
        Assertions.assertEquals((Object)this.annotationType, (Object)annotation.getType());
        Assertions.assertEquals((Object)ANNOTATION_LABEL, (Object)annotation.getValue());
    }

    @Test
    void addAnnotationNullValue() {
        TypeStructure structure = this.instance.addAnnotation((Type)this.annotationType).build();
        Assertions.assertEquals((int)0, (int)structure.getFields().size());
        Assertions.assertEquals((int)1, (int)structure.getAnnotations().size());
        Annotation annotation = (Annotation)structure.getAnnotations().get(0);
        Assertions.assertEquals((Object)this.annotationType, (Object)annotation.getType());
        Assertions.assertNull((Object)annotation.getValue());
    }
}

