/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openjdk.jmc.flightrecorder.writer.CompositeTypeImpl;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.SelfType;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeUtils;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class CompositeTypeImplTest {
    private static final String TYPE_NAME = "test.Type";
    private static final String FIELD_NAME = "field1";
    private static final String PARENT_FIELD_NAME = "parent";
    private static final String FIELD_VALUE = "hello";
    public static final int TYPE_ID = 1;
    private CompositeTypeImpl instance;
    private TypesImpl types;

    CompositeTypeImplTest() {
    }

    @BeforeEach
    void setUp() {
        ConstantPools constantPools = new ConstantPools();
        MetadataImpl metadata = new MetadataImpl(constantPools);
        this.types = new TypesImpl(metadata);
        ArrayList<TypedFieldImpl> fields = new ArrayList<TypedFieldImpl>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        fields.add(new TypedFieldImpl(this.types.getType((Types.Predefined)Types.Builtin.STRING), FIELD_NAME));
        fields.add(new TypedFieldImpl((TypeImpl)SelfType.INSTANCE, PARENT_FIELD_NAME));
        annotations.add(new Annotation((Type)this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_NAME), TYPE_NAME));
        TypeStructureImpl structure = new TypeStructureImpl(fields, annotations);
        this.instance = new CompositeTypeImpl(1L, TYPE_NAME, null, structure, constantPools, this.types);
    }

    @Test
    void typeSelfReferenceResolved() {
        for (TypedFieldImpl field : this.instance.getFields()) {
            if (!field.getName().equals(PARENT_FIELD_NAME)) continue;
            Assertions.assertNotEquals((Object)SelfType.INSTANCE, (Object)field.getType());
        }
    }

    @Test
    void isBuiltin() {
        Assertions.assertFalse((boolean)this.instance.isBuiltin());
    }

    @Test
    void getFields() {
        Assertions.assertEquals((int)2, (int)this.instance.getFields().size());
    }

    @Test
    void getField() {
        Assertions.assertNotNull((Object)this.instance.getField(FIELD_NAME));
        Assertions.assertNotNull((Object)this.instance.getField(PARENT_FIELD_NAME));
    }

    @Test
    void isResolved() {
        Assertions.assertTrue((boolean)this.instance.isResolved());
    }

    @Test
    void nullValue() {
        TypedValueImpl value = this.instance.nullValue();
        Assertions.assertNotNull((Object)value);
        Assertions.assertTrue((boolean)value.isNull());
        Assertions.assertEquals((Object)value, (Object)this.instance.nullValue());
    }

    @Test
    void getAnnotations() {
        Assertions.assertEquals((int)1, (int)this.instance.getAnnotations().size());
    }

    @Test
    void canAccept() {
        for (Types.Builtin builtin : Types.Builtin.values()) {
            for (Object builtinVal : TypeUtils.getBuiltinValues(builtin)) {
                Assertions.assertEquals((Object)(builtinVal == null ? 1 : 0), (Object)this.instance.canAccept(builtinVal));
            }
        }
        TypedValueImpl value = this.instance.asValue(builder -> builder.putField(FIELD_NAME, FIELD_VALUE));
        Assertions.assertTrue((boolean)this.instance.canAccept((Object)value));
    }

    @Test
    void getId() {
        Assertions.assertEquals((long)1L, (long)this.instance.getId());
    }

    @Test
    void getTypeName() {
        Assertions.assertEquals((Object)TYPE_NAME, (Object)this.instance.getTypeName());
    }

    @Test
    void getSupertype() {
        Assertions.assertNull((Object)this.instance.getSupertype());
    }

    @Test
    void isUsedBySimple() {
        TypeImpl other = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        Assertions.assertTrue((boolean)this.instance.isUsedBy((Type)this.instance));
        Assertions.assertFalse((boolean)this.instance.isUsedBy((Type)other));
        Assertions.assertTrue((boolean)other.isUsedBy((Type)this.instance));
    }

    @Test
    void isUsedByComplex() {
        TypeImpl target = this.types.getType((Types.Predefined)Types.Builtin.INT);
        TypeImpl main = this.types.getOrAdd("custom.Main", type -> type.addField(PARENT_FIELD_NAME, type.selfType()).addField("field", (Types.Predefined)Types.Builtin.STRING).addField("other", (Type)this.types.getType("custom.Other", true)));
        TypeImpl other = this.types.getOrAdd("custom.Other", type -> type.addField("loopback", (Type)main).addField("field", (Types.Predefined)Types.Builtin.INT));
        this.types.resolveAll();
        Assertions.assertFalse((boolean)this.instance.isUsedBy(null));
        Assertions.assertTrue((boolean)main.isUsedBy((Type)main));
        Assertions.assertTrue((boolean)main.isUsedBy((Type)other));
        Assertions.assertTrue((boolean)target.isUsedBy((Type)main));
    }

    @Test
    void testEquality() {
        TypeImpl type1 = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        TypeImpl type2 = this.types.getType((Types.Predefined)Types.Builtin.INT);
        TypeImpl type3 = this.types.getOrAdd("type.Custom", t -> t.addField(FIELD_NAME, (Type)this.types.getType((Types.Predefined)Types.Builtin.STRING)).addField("field2", (Type)this.types.getType((Types.Predefined)Types.Builtin.STRING)));
        Assertions.assertEquals((Object)type1, (Object)type1);
        Assertions.assertEquals((Object)type2, (Object)type2);
        Assertions.assertEquals((Object)type3, (Object)type3);
        Assertions.assertNotEquals((Object)type1, (Object)type2);
        Assertions.assertNotEquals((Object)type1, (Object)type3);
        Assertions.assertNotEquals((Object)type2, (Object)type1);
        Assertions.assertNotEquals((Object)type2, (Object)type3);
        Assertions.assertNotEquals((Object)type3, (Object)type1);
        Assertions.assertNotEquals((Object)type3, (Object)type2);
    }
}

