/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.openjdk.jmc.flightrecorder.writer.BaseType;
import org.openjdk.jmc.flightrecorder.writer.Chunk;
import org.openjdk.jmc.flightrecorder.writer.CompositeTypeImpl;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.LEB128Writer;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeUtils;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class ChunkTest {
    private Chunk instance;
    private LEB128Writer writer;
    private TypesImpl types;
    private MetadataImpl metadata;

    ChunkTest() {
    }

    @BeforeEach
    void setup() {
        this.writer = LEB128Writer.getInstance();
        this.instance = new Chunk();
        this.metadata = new MetadataImpl(new ConstantPools());
        this.types = new TypesImpl(this.metadata);
    }

    @Test
    void writeEventWrongType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.writeEvent(this.types.getType((Types.Predefined)Types.Builtin.STRING).asValue("value")));
    }

    @Test
    void writeNullValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.writeTypedValue(this.writer, null));
    }

    @ParameterizedTest
    @EnumSource(value=Types.Builtin.class)
    void writeBuiltinValue(Types.Builtin target) {
        for (Object value : TypeUtils.getBuiltinValues(target)) {
            TypeImpl type = this.types.getType((Types.Predefined)target);
            TypedValueImpl tv = new TypedValueImpl(type, value, 1L);
            this.instance.writeTypedValue(this.writer, tv);
            this.instance.writeTypedValue(this.writer, type.nullValue());
        }
    }

    @Test
    void writeUnknownBuiltin() {
        TypeImpl type = (TypeImpl)Mockito.mock(BaseType.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{1L, "unknown.Builtin", null, this.types}));
        Mockito.when((Object)type.isBuiltin()).thenReturn((Object)true);
        Mockito.when((Object)type.canAccept(ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.writeTypedValue(this.writer, new TypedValueImpl(type, (Object)"hello", 10L)));
    }

    @Test
    void writeCustomNoCP() {
        TypeImpl stringType = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        List<TypedFieldImpl> fields = Arrays.asList(new TypedFieldImpl(stringType, "string", false), new TypedFieldImpl(stringType, "strings", true));
        TypeStructureImpl structure = new TypeStructureImpl(fields, Collections.emptyList());
        CompositeTypeImpl type = new CompositeTypeImpl(1000L, "custom.Type", null, structure, null, this.types);
        this.instance.writeTypedValue(this.writer, type.asValue(v -> v.putField("string", "value1").putField("strings", new String[]{"value2", "value4"})));
    }
}

