/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValueBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class AnnotationTest {
    private TypesImpl types;

    AnnotationTest() {
    }

    @BeforeEach
    void setup() {
        ConstantPools constantPools = new ConstantPools();
        MetadataImpl metadata = new MetadataImpl(constantPools);
        this.types = new TypesImpl(metadata);
    }

    @Test
    void validAnnotationTypeNullValue() {
        TypeImpl type = this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_LABEL);
        Annotation annotation = new Annotation((Type)type);
        Assertions.assertNull((Object)annotation.getValue());
        Assertions.assertEquals((Object)type, (Object)annotation.getType());
    }

    @Test
    void validAnnotationTypeWithValue() {
        String value = "value";
        TypeImpl type = this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_LABEL);
        Annotation annotation = new Annotation((Type)type, value);
        Assertions.assertEquals((Object)type, (Object)annotation.getType());
        Assertions.assertEquals((Object)value, (Object)annotation.getValue());
    }

    @Test
    void validAnnotationWithArrayValue() {
        Object[] values = new String[]{"value1", "value2"};
        TypeImpl type = this.types.getType((Types.Predefined)Types.JDK.ANNOTATION_CATEGORY);
        Annotation annotation = new Annotation((Type)type, arg_0 -> AnnotationTest.lambda$validAnnotationWithArrayValue$0((String[])values, arg_0), new Annotation[0]);
        Assertions.assertEquals((Object)type, (Object)annotation.getType());
        Assertions.assertArrayEquals((Object[])values, (Object[])((Object[])annotation.getValue(String[].class, "value")));
    }

    @Test
    void invalidAnnotationType() {
        TypeImpl type = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Annotation((Type)type));
    }

    private static /* synthetic */ void lambda$validAnnotationWithArrayValue$0(String[] values, TypedValueBuilder access) {
        access.putField("value", values);
    }
}

