/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.osgibooter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tycho.surefire.osgibooter.OsgiSurefireBooter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;

public abstract class AbstractUITestApplication
implements ITestHarness {
    private static final String DEFAULT_APP_3_0 = "org.eclipse.ui.ide.workbench";
    private int fTestRunnerResult = -1;
    private String[] fArgs = new String[0];
    private TestableObject fTestableObject;

    public void runTests() {
        this.fTestableObject.testingStarting();
        if (this.useUIThread(this.fArgs)) {
            this.fTestableObject.runTest(new Runnable(){

                public void run() {
                    try {
                        AbstractUITestApplication.this.fTestRunnerResult = OsgiSurefireBooter.run(AbstractUITestApplication.this.fArgs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            try {
                this.fTestRunnerResult = OsgiSurefireBooter.run(this.fArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fTestableObject.testingFinished();
    }

    private boolean useUIThread(String[] args) {
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if ("-nouithread".equals(arg)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private Object getApplicationToRun(String[] args) throws CoreException {
        IConfigurationElement[] runs;
        String configuredApplication = this.getConfiguredApplication(args);
        if (configuredApplication == null) {
            configuredApplication = DEFAULT_APP_3_0;
        } else {
            System.out.println("Launching application " + configuredApplication + "...");
        }
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", configuredApplication);
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0) {
            return runs[0].createExecutableExtension("class");
        }
        return null;
    }

    private String getConfiguredApplication(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-testApplication") && i < args.length - 1) {
                return args[i + 1];
            }
            ++i;
        }
        return null;
    }

    protected Object run(String[] args) throws Exception {
        if (args != null) {
            this.fArgs = args;
        }
        this.fTestableObject = PlatformUI.getTestableObject();
        this.fTestableObject.setTestHarness((ITestHarness)this);
        try {
            Object application = this.getApplicationToRun(args);
            if (application == null) {
                return 200;
            }
            this.runApplication(application, args);
        }
        catch (Exception e) {
            if (this.fTestRunnerResult == -1) {
                throw e;
            }
            System.err.println("Caught unexpected exception during test framework shutdown");
            e.printStackTrace();
        }
        return this.fTestRunnerResult;
    }

    protected abstract void runApplication(Object var1, String[] var2) throws Exception;
}

