/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractBanDependencies;
import org.apache.maven.plugins.enforcer.utils.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireReleaseDeps
extends AbstractBanDependencies {
    private boolean onlyWhenRelease = false;
    private boolean failWhenParentIsSnapshot = true;
    private List<String> excludes = null;
    private List<String> includes = null;

    @Override
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project = null;
        boolean callSuper = this.onlyWhenRelease ? !(project = this.getProject(helper)).getArtifact().isSnapshot() : true;
        if (callSuper) {
            super.execute(helper);
            if (this.failWhenParentIsSnapshot) {
                Artifact parentArtifact;
                if (project == null) {
                    project = this.getProject(helper);
                }
                if ((parentArtifact = project.getParentArtifact()) != null && parentArtifact.isSnapshot()) {
                    throw new EnforcerRuleException("Parent Cannot be a snapshot: " + parentArtifact.getId());
                }
            }
        }
    }

    private MavenProject getProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            return (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
    }

    @Override
    protected Set<Artifact> checkDependencies(Set<Artifact> dependencies, Log log) throws EnforcerRuleException {
        HashSet<Artifact> foundSnapshots = new HashSet<Artifact>();
        Set<Artifact> filteredDependencies = this.filterArtifacts(dependencies);
        for (Artifact artifact : filteredDependencies) {
            if (!artifact.isSnapshot()) continue;
            foundSnapshots.add(artifact);
        }
        return foundSnapshots;
    }

    protected Set<Artifact> filterArtifacts(Set<Artifact> dependencies) throws EnforcerRuleException {
        Set<Artifact> excluded;
        if (this.includes == null && this.excludes == null) {
            return dependencies;
        }
        Set<Artifact> included = this.includes != null ? ArtifactUtils.checkDependencies(dependencies, this.includes) : new HashSet<Artifact>(dependencies);
        if (included != null && (excluded = ArtifactUtils.checkDependencies(dependencies, this.excludes)) != null) {
            included.removeAll(excluded);
        }
        return included;
    }

    public final boolean isOnlyWhenRelease() {
        return this.onlyWhenRelease;
    }

    public final void setOnlyWhenRelease(boolean onlyWhenRelease) {
        this.onlyWhenRelease = onlyWhenRelease;
    }

    public final boolean isFailWhenParentIsSnapshot() {
        return this.failWhenParentIsSnapshot;
    }

    public final void setFailWhenParentIsSnapshot(boolean failWhenParentIsSnapshot) {
        this.failWhenParentIsSnapshot = failWhenParentIsSnapshot;
    }

    public final void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public final List<String> getExcludes() {
        return this.excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }
}

