/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.module;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.repository.module.ModuleArtifactRepository;
import org.eclipse.tycho.repository.module.ModuleArtifactRepositoryDelegate;
import org.eclipse.tycho.repository.module.ModuleMetadataRepository;
import org.eclipse.tycho.repository.module.PublishingRepositoryLoader;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;
import org.eclipse.tycho.repository.publishing.PublishingRepository;
import org.eclipse.tycho.repository.publishing.WriteSessionContext;

public class PublishingRepositoryImpl
implements PublishingRepository {
    private final ReactorProjectIdentities project;
    private final ModuleMetadataRepository metadataRepository;
    private final ModuleArtifactRepository artifactRepository;

    public PublishingRepositoryImpl(IProvisioningAgent agent, ReactorProjectIdentities project) {
        this.project = project;
        PublishingRepositoryLoader loadHelper = new PublishingRepositoryLoader(agent, project);
        this.metadataRepository = loadHelper.getModuleMetadataRepository();
        this.artifactRepository = loadHelper.getModuleArtifactRepository();
    }

    @Override
    public ReactorProjectIdentities getProjectIdentities() {
        return this.project;
    }

    @Override
    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    public Set<Object> getInstallableUnits() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.getMetadataRepository().query(QueryUtil.ALL_UNITS, null).toSet());
        return result;
    }

    @Override
    public IRawArtifactFileProvider getArtifacts() {
        return this.artifactRepository;
    }

    @Override
    public IFileArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    @Override
    public IArtifactRepository getArtifactRepositoryForWriting(WriteSessionContext writeSession) {
        return new ModuleArtifactRepositoryDelegate(this.artifactRepository, writeSession);
    }

    @Override
    public void addArtifactLocation(String classifier, File artifactLocation) throws ProvisionException {
        this.artifactRepository.getArtifactsMap().add(classifier, artifactLocation);
    }

    public Map<String, File> getArtifactLocations() {
        Map<String, File> artifactLocations = this.artifactRepository.getArtifactsMap().getLocalArtifactLocations();
        artifactLocations.put("p2metadata", this.metadataRepository.getPersistenceFile());
        return artifactLocations;
    }
}

