/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.IOException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.AbstractArtifactBasedProject;
import org.eclipse.tycho.core.osgitools.AbstractArtifactDependencyWalker;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.model.UpdateSite;

@Component(role=TychoProject.class, hint="eclipse-update-site")
public class UpdateSiteProject
extends AbstractArtifactBasedProject {
    @Override
    protected ArtifactDependencyWalker newDependencyWalker(MavenProject project, TargetEnvironment environment) {
        final UpdateSite site = this.loadSite(project);
        return new AbstractArtifactDependencyWalker(this.getDependencyArtifacts(project, environment), this.getEnvironments(project, environment)){

            @Override
            public void walk(ArtifactDependencyVisitor visitor) {
                this.traverseUpdateSite(site, visitor);
            }
        };
    }

    private UpdateSite loadSite(MavenProject project) {
        File file = new File(project.getBasedir(), "site.xml");
        try {
            return UpdateSite.read((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read site.xml " + file.getAbsolutePath(), e);
        }
    }

    @Override
    public ArtifactKey getArtifactKey(ReactorProject project) {
        return new DefaultArtifactKey("eclipse-update-site", project.getArtifactId(), this.getOsgiVersion(project));
    }
}

