/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.List;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.classpath.ClasspathEntry;

public class DefaultClasspathEntry
implements ClasspathEntry {
    private final ReactorProject project;
    private final ArtifactKey key;
    private final List<File> locations;
    private final List<ClasspathEntry.AccessRule> rules;

    public DefaultClasspathEntry(ReactorProject project, ArtifactKey key, List<File> locations, List<ClasspathEntry.AccessRule> rules) {
        this.project = project;
        this.key = key;
        this.locations = locations;
        this.rules = rules;
    }

    public List<File> getLocations() {
        return this.locations;
    }

    public List<ClasspathEntry.AccessRule> getAccessRules() {
        return this.rules;
    }

    public ArtifactKey getArtifactKey() {
        return this.key;
    }

    public ReactorProject getMavenProject() {
        return this.project;
    }

    public static class DefaultAccessRule
    implements ClasspathEntry.AccessRule {
        private final String pattern;
        private final boolean discouraged;

        public DefaultAccessRule(String path, boolean discouraged) {
            if (path == null) {
                throw new NullPointerException();
            }
            this.pattern = path;
            this.discouraged = discouraged;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ClasspathEntry.AccessRule)) {
                return false;
            }
            ClasspathEntry.AccessRule other = (ClasspathEntry.AccessRule)obj;
            return this.isDiscouraged() == other.isDiscouraged() && this.getPattern().equals(other.getPattern());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.discouraged ? 1231 : 1237);
            result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
            return result;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String toString() {
            return this.getPattern();
        }

        public boolean isDiscouraged() {
            return this.discouraged;
        }
    }
}

