/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.openjdk.jmc.common.collection.BoundedList;
import org.openjdk.jmc.common.test.SlowTests;

public class BoundedListTest {
    @Test
    public void testAdd() {
        BoundedList bl = new BoundedList(10);
        bl.add((Object)1);
        bl.add((Object)2);
        Assert.assertEquals((long)2L, (long)bl.getSize());
        Assert.assertEquals((long)10L, (long)bl.getMaxSize());
    }

    @Test
    public void testBasicIterator() {
        BoundedList bl = new BoundedList(10);
        bl.add((Object)1);
        bl.add((Object)2);
        bl.add((Object)3);
        int val = 1;
        for (Integer iterVal : bl) {
            Assert.assertEquals((long)val++, (long)iterVal.intValue());
        }
        Assert.assertEquals((long)4L, (long)val);
    }

    @Test
    public void testWrappingIterator() {
        BoundedList bl = new BoundedList(10);
        for (int i = 1; i <= 20; ++i) {
            bl.add((Object)i);
        }
        int val = 11;
        for (Integer iterVal : bl) {
            Assert.assertEquals((long)val++, (long)iterVal.intValue());
        }
    }

    @Test
    public void testEmptyIterator() {
        BoundedList bl = new BoundedList(10);
        Assert.assertFalse((String)"Empty list should have no elements!", (boolean)bl.iterator().hasNext());
        try {
            bl.iterator().next();
            Assert.fail((String)"next should have generated an exception!");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleIterators() {
        BoundedList bl = new BoundedList(10);
        for (int i = 1; i <= 10; ++i) {
            bl.add((Object)i);
        }
        Iterator iter1 = bl.iterator();
        for (int i = 11; i <= 20; ++i) {
            bl.add((Object)i);
        }
        Iterator iter2 = bl.iterator();
        int val1 = 1;
        while (iter1.hasNext()) {
            Assert.assertEquals((long)val1++, (long)((Integer)iter1.next()).intValue());
        }
        int val2 = 11;
        while (iter2.hasNext()) {
            Assert.assertEquals((long)val2++, (long)((Integer)iter2.next()).intValue());
        }
        Assert.assertEquals((long)11L, (long)val1);
        Assert.assertEquals((long)21L, (long)val2);
    }

    @Category(value={SlowTests.class})
    @Test
    public void testMultiThreadedConsumption() throws InterruptedException {
        BoundedList bl = new BoundedList(20);
        ProducerThread t = new ProducerThread((BoundedList<Long>)bl);
        ValidationThread[] validators = new ValidationThread[10];
        new Thread((Runnable)t, "Producer").start();
        for (int i = 0; i < validators.length; ++i) {
            validators[i] = new ValidationThread((BoundedList<Long>)bl);
            new Thread((Runnable)validators[i], "Validator " + i).start();
        }
        Thread.sleep(30000L);
        for (ValidationThread validator : validators) {
            validator.stop();
        }
        t.stop();
        long maxNo = 0L;
        for (ValidationThread validator : validators) {
            Assert.assertEquals((String)"Failed count validation!", (long)-1L, (long)validator.countError);
            Assert.assertEquals((String)"Failed sequence validation!", (long)-1L, (long)validator.sequenceError);
            maxNo = Math.max(maxNo, validator.maxNum);
        }
        System.out.println("Allocated up to " + t.counter);
        System.out.println("Max no was " + maxNo);
    }

    private static class ValidationThread
    implements Runnable {
        private final BoundedList<Long> list;
        private volatile boolean shouldStop = false;
        private volatile long countError = -1L;
        private volatile long sequenceError = -1L;
        private volatile long maxNum;

        public ValidationThread(BoundedList<Long> list) {
            this.list = list;
        }

        @Override
        public void run() {
            while (!this.shouldStop) {
                this.validate();
            }
        }

        private void validate() {
            int count = 0;
            long lastNumber = -1L;
            for (Long l : this.list) {
                if (lastNumber != -1L && l - lastNumber != 1L) {
                    this.sequenceError = l - lastNumber;
                }
                ++count;
                this.maxNum = Math.max(l, this.maxNum);
            }
            if (count > this.list.getMaxSize()) {
                this.countError = count;
            }
        }

        public void stop() {
            this.shouldStop = true;
        }
    }

    private static class ProducerThread
    implements Runnable {
        private final BoundedList<Long> list;
        private volatile boolean shouldStop = false;
        private long counter;

        public ProducerThread(BoundedList<Long> list) {
            this.list = list;
        }

        @Override
        public void run() {
            while (!this.shouldStop) {
                for (int i = 0; i < 100000; ++i) {
                    this.list.add((Object)this.counter++);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Thread.yield();
            }
        }

        public void stop() {
            this.shouldStop = true;
        }
    }
}

