/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;

public class OverlappingEventsTest {
    @Test
    public void testStartTime() throws IOException, CouldNotLoadRecordingException {
        IItemCollection overlap = RecordingToolkit.getNamedRecording("overlap.jfr").apply(ItemFilters.type((String)"org.openjdk.jmc.test.OverlappingEvent"));
        IAggregator first = Aggregators.min((IAttribute)JfrAttributes.START_TIME);
        IQuantity expected = (IQuantity)overlap.getAggregate(first);
        IQuantity actual = RulesToolkit.getEarliestStartTime((IItemCollection)overlap).in(expected.getUnit());
        Assert.assertEquals((String)("expected: " + expected.displayUsing("auto") + ", actual: " + actual.displayUsing("auto")), (Object)expected, (Object)actual);
    }

    @Test
    public void testFirstEndTime() throws IOException, CouldNotLoadRecordingException {
        IItemCollection overlap = RecordingToolkit.getNamedRecording("overlap.jfr").apply(ItemFilters.type((String)"org.openjdk.jmc.test.OverlappingEvent"));
        IAggregator min = Aggregators.min((IAttribute)JfrAttributes.END_TIME);
        IQuantity expected = (IQuantity)overlap.getAggregate(min);
        IQuantity actual = RulesToolkit.getEarliestEndTime((IItemCollection)overlap).in(expected.getUnit());
        Assert.assertEquals((String)("expected: " + expected.displayUsing("auto") + ", actual: " + actual.displayUsing("auto")), (Object)expected, (Object)actual);
    }

    @Test
    public void testLastEndTime() throws IOException, CouldNotLoadRecordingException {
        IItemCollection overlap = RecordingToolkit.getNamedRecording("overlap.jfr").apply(ItemFilters.type((String)"org.openjdk.jmc.test.OverlappingEvent"));
        IAggregator last = Aggregators.max((IAttribute)JfrAttributes.END_TIME);
        IQuantity aggregatedLast = ((IQuantity)overlap.getAggregate(last)).in((IUnit)UnitLookup.EPOCH_NS);
        IQuantity actual = RulesToolkit.getLatestEndTime((IItemCollection)overlap).in((IUnit)UnitLookup.EPOCH_NS);
        Assert.assertEquals((String)("expected: " + aggregatedLast.displayUsing("auto") + ", actual: " + actual.displayUsing("auto")), (Object)aggregatedLast, (Object)actual);
    }
}

