/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.dotClasspath.ProjectClasspathEntry;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProject;
import org.eclipse.tycho.core.shared.BuildProperties;

public class EclipsePluginProjectImpl
implements EclipsePluginProject {
    private final ReactorProject project;
    private final BuildProperties buildProperties;
    private final LinkedHashMap<String, BuildOutputJar> outputJars = new LinkedHashMap();
    private final BuildOutputJar dotOutputJar;
    private Collection<ProjectClasspathEntry> classpathEntries;

    public EclipsePluginProjectImpl(ReactorProject project, BuildProperties buildProperties, Collection<ProjectClasspathEntry> classpathEntries) throws IOException {
        this.project = project;
        this.buildProperties = buildProperties;
        this.classpathEntries = classpathEntries;
        LinkedHashMap<String, BuildOutputJar> jars = new LinkedHashMap<String, BuildOutputJar>();
        for (String jarName : buildProperties.getJarsCompileOrder()) {
            jars.put(jarName, null);
        }
        ArrayList<String> extraClasspath = new ArrayList<String>();
        extraClasspath.addAll(buildProperties.getJarsExtraClasspath());
        String dotJarName = null;
        Set jarToSourceFolderEntries = buildProperties.getJarToSourceFolderMap().entrySet();
        for (Map.Entry entry : jarToSourceFolderEntries) {
            File outputDirectory;
            String jarName = (String)entry.getKey();
            if (".".equals(jarName) || jarToSourceFolderEntries.size() == 1) {
                dotJarName = jarName;
                outputDirectory = project.getBuildDirectory().getOutputDirectory();
            } else {
                String classesDir = jarName;
                if (jarName.endsWith("/")) {
                    classesDir = jarName.substring(0, jarName.length() - 1);
                }
                outputDirectory = project.getBuildDirectory().getChild(classesDir + "-classes");
            }
            List<File> sourceFolders = this.toFileList(project.getBasedir(), (List)entry.getValue());
            List<String> excludeFiles = buildProperties.getJarToExcludeFileMap().getOrDefault(jarName, Collections.emptyList());
            List jarExtraEntries = (List)buildProperties.getJarToExtraClasspathMap().get(jarName);
            if (jarExtraEntries != null) {
                extraClasspath.addAll(jarExtraEntries);
            }
            jars.put(jarName, new BuildOutputJar(jarName, outputDirectory, sourceFolders, extraClasspath, excludeFiles));
        }
        this.dotOutputJar = dotJarName != null ? (BuildOutputJar)jars.get(dotJarName) : null;
        for (BuildOutputJar jar : jars.values()) {
            if (jar == null) continue;
            this.outputJars.put(jar.getName(), jar);
        }
    }

    private List<File> toFileList(File parent, List<String> names) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        for (String name : names) {
            result.add(new File(new File(parent, name).toURI().normalize()));
        }
        return result;
    }

    @Override
    public ReactorProject getMavenProject() {
        return this.project;
    }

    @Override
    public List<BuildOutputJar> getOutputJars() {
        return new ArrayList<BuildOutputJar>(this.outputJars.values());
    }

    @Override
    public Collection<ProjectClasspathEntry> getClasspathEntries() {
        return Collections.unmodifiableCollection(this.classpathEntries);
    }

    @Override
    public BuildOutputJar getDotOutputJar() {
        return this.dotOutputJar;
    }

    @Override
    public Map<String, BuildOutputJar> getOutputJarMap() {
        return this.outputJars;
    }

    @Override
    public BuildProperties getBuildProperties() {
        return this.buildProperties;
    }
}

