/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.dotClasspath;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.core.dotClasspath.ClasspathContainerEntry;
import org.eclipse.tycho.core.dotClasspath.JREClasspathEntry;
import org.eclipse.tycho.core.dotClasspath.JUnitClasspathContainerEntry;
import org.eclipse.tycho.core.dotClasspath.LibraryClasspathEntry;
import org.eclipse.tycho.core.dotClasspath.M2ClasspathVariable;
import org.eclipse.tycho.core.dotClasspath.ProjectClasspathEntry;
import org.eclipse.tycho.core.dotClasspath.SourceFolderClasspathEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component(role=ClasspathParser.class)
public class ClasspathParser
implements Disposable {
    private Map<String, JDTClasspath> cache = new ConcurrentHashMap<String, JDTClasspath>();

    public void dispose() {
        this.cache.clear();
    }

    public Collection<ProjectClasspathEntry> parse(File basedir) throws IOException {
        File file = new File(basedir, ".classpath");
        if (file.exists()) {
            return this.cache.computeIfAbsent(file.getCanonicalPath(), f -> new JDTClasspath(file)).getEntries();
        }
        return Collections.emptyList();
    }

    private static final class JDTClasspath {
        private File file;
        private List<ProjectClasspathEntry> entries;

        public JDTClasspath(File file) {
            this.file = file;
        }

        public synchronized Collection<ProjectClasspathEntry> getEntries() throws IOException {
            if (this.entries == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    Element classpathentry;
                    int i;
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(this.file);
                    NodeList classpathentries = doc.getDocumentElement().getElementsByTagName("classpathentry");
                    int length = classpathentries.getLength();
                    ArrayList<ProjectClasspathEntry> list = new ArrayList<ProjectClasspathEntry>();
                    String defaultOutput = "bin";
                    for (i = 0; i < length; ++i) {
                        classpathentry = (Element)classpathentries.item(i);
                        String kind = classpathentry.getAttribute("kind");
                        if (!"output".equals(kind)) continue;
                        defaultOutput = classpathentry.getAttribute("path");
                    }
                    for (i = 0; i < length; ++i) {
                        String path;
                        classpathentry = (Element)classpathentries.item(i);
                        Map<String, String> attributes = this.getAttributes(classpathentry);
                        String kind = classpathentry.getAttribute("kind");
                        if ("src".equals(kind)) {
                            path = classpathentry.getAttribute("path");
                            String output = classpathentry.getAttribute("output");
                            if (output.isBlank()) {
                                output = defaultOutput;
                            }
                            list.add(new JDTSourceFolder(new File(this.file.getParentFile(), path), new File(this.file.getParentFile(), output), attributes));
                            continue;
                        }
                        if ("con".equals(kind)) {
                            path = classpathentry.getAttribute("path");
                            if (path.startsWith("org.eclipse.jdt.junit.JUNIT_CONTAINER/")) {
                                String junit = path.substring("org.eclipse.jdt.junit.JUNIT_CONTAINER/".length());
                                list.add(new JDTJUnitContainerClasspathEntry(path, junit, attributes));
                                continue;
                            }
                            if (path.equals("org.eclipse.jdt.launching.JRE_CONTAINER") || path.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/")) {
                                list.add(new JDTJREClasspathEntry(path, attributes));
                                continue;
                            }
                            list.add(new JDTContainerClasspathEntry(path, attributes));
                            continue;
                        }
                        if ("lib".equals(kind)) {
                            path = classpathentry.getAttribute("path");
                            list.add(new JDTLibraryClasspathEntry(new File(this.file.getParentFile(), path), attributes));
                            continue;
                        }
                        if (!"var".equals(kind) || !(path = classpathentry.getAttribute("path")).startsWith("M2_REPO/")) continue;
                        String repoPath = path.substring("M2_REPO/".length());
                        list.add(new M2E(repoPath, attributes));
                    }
                    this.entries = Collections.unmodifiableList(list);
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e);
                }
                catch (SAXException e) {
                    throw new IOException(e);
                }
            }
            return this.entries;
        }

        private Map<String, String> getAttributes(Element parent) {
            HashMap<String, String> map = new HashMap<String, String>();
            NodeList attributes = parent.getElementsByTagName("attribute");
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Element attribute = (Element)attributes.item(i);
                map.put(attribute.getAttribute("name"), attribute.getAttribute("value"));
            }
            return map;
        }
    }

    private static final class JDTLibraryClasspathEntry
    implements LibraryClasspathEntry {
        private final File path;
        private final Map<String, String> attributes;

        public JDTLibraryClasspathEntry(File path, Map<String, String> attributes) {
            this.path = path;
            this.attributes = attributes;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public File getLibraryPath() {
            return this.path;
        }
    }

    private static final class M2E
    implements M2ClasspathVariable {
        private final String repoPath;
        private final Map<String, String> attributes;

        M2E(String repoPath, Map<String, String> attributes) {
            this.repoPath = repoPath;
            this.attributes = attributes;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String getRepositoryPath() {
            return this.repoPath;
        }
    }

    private static final class JDTSourceFolder
    implements SourceFolderClasspathEntry {
        private final File path;
        private final Map<String, String> attributes;
        private final File output;

        public JDTSourceFolder(File path, File output, Map<String, String> attributes) {
            this.path = path;
            this.output = output;
            this.attributes = attributes;
        }

        @Override
        public File getSourcePath() {
            return this.path;
        }

        @Override
        public File getOutputFolder() {
            return this.output;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }
    }

    private static class JDTContainerClasspathEntry
    implements ClasspathContainerEntry {
        protected final String path;
        protected final Map<String, String> attributes;

        public JDTContainerClasspathEntry(String path, Map<String, String> attributes) {
            this.path = path;
            this.attributes = attributes;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String getContainerPath() {
            return this.path;
        }
    }

    private static class JDTJUnitContainerClasspathEntry
    extends JDTContainerClasspathEntry
    implements JUnitClasspathContainerEntry {
        private final String junit;

        public JDTJUnitContainerClasspathEntry(String path, String junit, Map<String, String> attributes) {
            super(path, attributes);
            this.junit = junit;
        }

        @Override
        public String getJUnitSegment() {
            return this.junit;
        }

        @Override
        public Collection<ArtifactKey> getArtifacts() {
            if ("3".equals(this.junit)) {
                return Arrays.asList(JUNIT3_PLUGIN);
            }
            if ("4".equals(this.junit)) {
                return Arrays.asList(JUNIT4_PLUGIN, HAMCREST_CORE_PLUGIN);
            }
            if ("5".equals(this.junit)) {
                return Arrays.asList(JUNIT_JUPITER_API_PLUGIN, JUNIT_JUPITER_ENGINE_PLUGIN, JUNIT_JUPITER_MIGRATIONSUPPORT_PLUGIN, JUNIT_JUPITER_PARAMS_PLUGIN, JUNIT_PLATFORM_COMMONS_PLUGIN, JUNIT_PLATFORM_ENGINE_PLUGIN, JUNIT_PLATFORM_LAUNCHER_PLUGIN, JUNIT_PLATFORM_RUNNER_PLUGIN, JUNIT_PLATFORM_SUITE_API_PLUGIN, JUNIT_VINTAGE_ENGINE_PLUGIN, JUNIT_OPENTEST4J_PLUGIN, JUNIT_APIGUARDIAN_PLUGIN, JUNIT4_PLUGIN, HAMCREST_CORE_PLUGIN);
            }
            return Collections.emptyList();
        }
    }

    private static final class JDTJREClasspathEntry
    extends JDTContainerClasspathEntry
    implements JREClasspathEntry {
        public JDTJREClasspathEntry(String path, Map<String, String> attributes) {
            super(path, attributes);
        }

        @Override
        public boolean isModule() {
            return Boolean.valueOf((String)this.attributes.get("module"));
        }

        @Override
        public Collection<String> getLimitModules() {
            String modules = (String)this.attributes.get("limit-modules");
            if (modules != null) {
                return Arrays.asList(modules.split(","));
            }
            return Collections.emptyList();
        }

        @Override
        public String getJREName() {
            if (this.path.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/")) {
                return this.path.substring("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/".length());
            }
            return null;
        }
    }
}

