/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.artifacts.configuration;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.artifacts.TargetPlatformFilter;
import org.eclipse.tycho.artifacts.TargetPlatformFilterSyntaxException;

@Component(role=TargetPlatformFilterConfigurationReader.class)
public class TargetPlatformFilterConfigurationReader {
    public List<TargetPlatformFilter> parseFilterConfiguration(Xpp3Dom filtersElement) {
        ArrayList<TargetPlatformFilter> result = new ArrayList<TargetPlatformFilter>();
        for (Xpp3Dom filterDom : filtersElement.getChildren()) {
            this.parseFilter(filterDom, result);
        }
        return result;
    }

    private void parseFilter(Xpp3Dom filterDom, List<TargetPlatformFilter> result) {
        TargetPlatformFilter filter;
        TargetPlatformFilter.CapabilityPattern scopePattern = this.parseScopePattern(filterDom);
        Xpp3Dom restrictToDom = TargetPlatformFilterConfigurationReader.getComplexValue(filterDom, "restrictTo");
        Xpp3Dom removeAllDom = TargetPlatformFilterConfigurationReader.getMarker(filterDom, "removeAll");
        if (removeAllDom == null && restrictToDom == null) {
            throw new TargetPlatformFilterSyntaxException("Filter action is required: specify either 'filters.filter.removeAll' or 'filters.filter.restrictTo'");
        }
        if (removeAllDom != null && restrictToDom != null) {
            throw new TargetPlatformFilterSyntaxException("Only one filter action may be specified: either 'filters.filter.removeAll' or 'filters.filter.restrictTo'");
        }
        if (removeAllDom != null) {
            filter = TargetPlatformFilter.removeAllFilter((TargetPlatformFilter.CapabilityPattern)scopePattern);
        } else {
            TargetPlatformFilter.CapabilityPattern restrictionPattern = this.parseRestrictionPattern(restrictToDom);
            filter = TargetPlatformFilter.restrictionFilter((TargetPlatformFilter.CapabilityPattern)scopePattern, (TargetPlatformFilter.CapabilityPattern)restrictionPattern);
        }
        result.add(filter);
    }

    private TargetPlatformFilter.CapabilityPattern parseScopePattern(Xpp3Dom filterDom) {
        PatternParser scopeParser = new PatternParser(filterDom, "filters.filter");
        scopeParser.readPatternType(true);
        scopeParser.readPatternId(true);
        scopeParser.readVersionOrVersionRange();
        return scopeParser.buildPattern();
    }

    private TargetPlatformFilter.CapabilityPattern parseRestrictionPattern(Xpp3Dom restrictToDom) {
        PatternParser restrictionParser = new PatternParser(restrictToDom, "filters.filter.restrictTo");
        restrictionParser.readPatternType(false);
        restrictionParser.readPatternId(false);
        restrictionParser.readVersionOrVersionRange();
        return restrictionParser.buildPattern();
    }

    private static TargetPlatformFilter.CapabilityType getTypeValue(Xpp3Dom dom) {
        String typeString = TargetPlatformFilterConfigurationReader.getSimpleValue(dom, "type");
        if (typeString == null) {
            return null;
        }
        return TargetPlatformFilter.CapabilityType.parsePomValue((String)typeString);
    }

    private static String getSimpleValue(Xpp3Dom dom, String elementName) {
        Xpp3Dom element = dom.getChild(elementName);
        if (element == null) {
            return null;
        }
        return element.getValue();
    }

    private static Xpp3Dom getComplexValue(Xpp3Dom dom, String elementName) {
        return dom.getChild(elementName);
    }

    private static Xpp3Dom getMarker(Xpp3Dom dom, String elementName) {
        return dom.getChild(elementName);
    }

    private static class PatternParser {
        private final Xpp3Dom baseElement;
        private final String baseElementPath;
        private TargetPlatformFilter.CapabilityType type;
        private String id;
        private String version;
        private String versionRange;

        PatternParser(Xpp3Dom baseElement, String baseElementPath) {
            this.baseElement = baseElement;
            this.baseElementPath = baseElementPath;
        }

        private void readPatternType(boolean required) {
            this.type = TargetPlatformFilterConfigurationReader.getTypeValue(this.baseElement);
            if (required && this.type == null) {
                throw new TargetPlatformFilterSyntaxException("Attribute '" + this.baseElementPath + ".type' is required");
            }
        }

        private void readPatternId(boolean required) {
            this.id = TargetPlatformFilterConfigurationReader.getSimpleValue(this.baseElement, "id");
            if (required && this.id == null) {
                throw new TargetPlatformFilterSyntaxException("Attribute '" + this.baseElementPath + ".id' is required");
            }
        }

        private void readVersionOrVersionRange() {
            this.version = TargetPlatformFilterConfigurationReader.getSimpleValue(this.baseElement, "version");
            this.versionRange = TargetPlatformFilterConfigurationReader.getSimpleValue(this.baseElement, "versionRange");
            if (this.version != null && this.versionRange != null) {
                throw new TargetPlatformFilterSyntaxException("Only one of the following attributes may be specified: '" + this.baseElementPath + ".version' or '" + this.baseElementPath + ".versionRange'");
            }
        }

        private TargetPlatformFilter.CapabilityPattern buildPattern() {
            if (this.version == null) {
                return TargetPlatformFilter.CapabilityPattern.patternWithVersionRange((TargetPlatformFilter.CapabilityType)this.type, (String)this.id, (String)this.versionRange);
            }
            return TargetPlatformFilter.CapabilityPattern.patternWithVersion((TargetPlatformFilter.CapabilityType)this.type, (String)this.id, (String)this.version);
        }
    }
}

